import random
import re
import string

from lxml import etree


STRING_LEN_MIN = 1
STRING_LEN_MAX = 99

NUMBER_MIN = 0
NUMBER_MAX = 1000

exclude_regex = re.compile('^(\{.*\})(.*)$')


def node_copy(node):
    """Utility for copying nodes.

    :returns: :class:`etree.Element`

    """
    new_node = etree.Element(node.tag, **node.attrib)
    new_node.text = node.text
    new_node.tail = node.tail
    return new_node


def clean_tag_name(node):
    """Utility for cleaning up node names, specifically removing
    namespace information from a tag name.

    :returns: :class:`str`

    """
    regex_res = exclude_regex.match(node.tag)
    if regex_res:
        clean_node_tag = regex_res.groups()[1]
    else:
        clean_node_tag = node.tag
    return clean_node_tag


def random_string():
    return ''.join((random.choice(string.letters + string.digits)
                for _ in xrange(random.randint(STRING_LEN_MIN, STRING_LEN_MAX))))


def random_number():
    return random.randint(NUMBER_MIN, NUMBER_MAX)


def random_float():
    return random.random()
