import random

from lxml import etree

from xmltrans.handlers import ElementHandler


class TranscriptionHandler(ElementHandler):
    """Returns new node instance with ``node.attrib['name']`` as a tag name.

    :param node: Node to be processed.
    :returns: :class:`etree.Element`

    """    
    def _process(self, node):
        new_node = etree.Element(node.attrib['name'])
        return new_node


class RandomValueHandler(ElementHandler):
    """Used with `restriction` XML Schema element, randomly selects one of the
    children and returns its ``node.attrib['value']``.

    :param node: Node to be processed.
    :returns: :class:`unicode`

    """    
    def _process(self, node):
        children = node.getchildren()
        selection = children[random.randint(0, len(children)-1)]
        return selection.attrib['value']
