from xmltrans.generators import DataGenerator
from xmltrans.utils import (
    random_string,
    random_number,
    random_float,
)


class ValidDataGenerator(DataGenerator):
    """Generates data according to the XML Schema type of a given element.

    """
    def _generate(self, node):
        if 'type' in node.attrib:
            if 'string' in node.attrib['type']:
                return random_string()
            elif 'integer' in node.attrib['type']:
                return random_number()
            elif 'float' in node.attrib['type']:
                return random_float()
        return None


class StringDataGenerator(DataGenerator):
    """Returns random string ignoring element type.

    """
    def _generate(self, node):
        return random_string()


class MixedDataGenerator(DataGenerator):
    """Combines :class:`StringDataGenerator` and :class:`ValidDataGenerator`.

    """
    def _generate(self, node):
        if 'type' in node.attrib:
            if 'string' in node.attrib['type']:
                return random_string()
            elif 'integer' in node.attrib['type']:
                return random_number()
            elif 'float' in node.attrib['type']:
                return random_float()
        else:
            return random_string()
