#!/usr/bin/env python
from comtypes import COMError
import string

def com_stringgetter(fun):
    def newfun(self):
        strlen = 128
        succeeded = False
        while not succeeded:
            try:
                str = u' '*strlen
                str = getattr(self, '_'+fun.__name__)(str, strlen)
                str = string.rstrip(str, '\x00')
                return str
            except COMError, ce:
                if ce.hresult in [-2147024882, -2147201016]:
                    strlen = strlen*2
                else:
                    raise ce
    return newfun