#This file is part of Tryton.  The COPYRIGHT file at the top level of
#this repository contains the full copyright notices and license terms.
from trytond.model import ModelView, ModelSQL, ModelSingleton, fields

__all__ = ['DocumentConfiguration']


class DocumentConfiguration(ModelSingleton, ModelSQL, ModelView):
    'Document Configuration'
    __name__ = 'document.configuration'
    document_reception_sequence = fields.Property(fields.Many2One('ir.sequence',
        'Doc. Reception Sequence', required=True, domain=[
                ('code', '=', 'document.document')])
                )
