#!/usr/bin/env python

import sys
from distutils.core import setup

# patch distutils if it can't cope with the "classifiers" or
# "download_url" keywords
if sys.version < '2.2.3':
	from distutils.dist import DistributionMetadata
	DistributionMetadata.classifiers = None
	DistributionMetadata.download_url = None

setup(	name				= "tplcompiler",
		version				= "1.0.5",
		description			= "Tool to compile phpBB-style templates to Python modules",
		long_description	= "This tool compiles a phpBB-style template into a Python module,\nwhich can then be called with a data dictionary to apply that data\nto the template.",
		author				= "Sander Steffann",
		author_email		= "steffann@nederland.net",
		license				= "GPL",
		platforms			= ['All'],
		url					= "http://opensource.nederland.net/tplcompiler/",
		download_url		= "http://opensource.nederland.net/tplcompiler/tplcompiler-1.0.5.tar.gz",
		scripts				= ["tplcompiler"],
		classifiers			= [
								"Development Status :: 5 - Production/Stable",
								"Environment :: Console",
								"Intended Audience :: Developers",
								"License :: OSI Approved :: GNU General Public License (GPL)",
								"Operating System :: OS Independent",
								"Programming Language :: Python",
								"Topic :: Software Development :: Code Generators",
								"Topic :: Software Development :: Compilers",
							  ],
     )
