import pytest

from TestHelper import Singleton


# noinspection PyMethodParameters
# noinspection PyUnresolvedReferences
class PytestTester(object):
    __metaclass__ = Singleton
    test_logger = None
    tlib_logger = None

    @pytest.fixture(scope='function', autouse=True)
    def log(self, request, test_logger):
        test_logger.info("======================== START %s ========================" % request.keywords.node.name)

        def log_end():
            test_logger.info("======================== END %s ========================" % request.keywords.node.name)

        request.addfinalizer(log_end)

    # noinspection PyPep8Naming
    @pytest.fixture(scope='class', autouse=True)
    def initialize_PytestTester_class(self, request, test_logger, tlib_logger):
        """
        @type request: FixtureRequest
        @type test_logger: logging
        @type tlib_logger: logging
        """
        #Store an instance of browser and loggers to be used from code that doesn't have access to this information
        setattr(PytestTester, 'test_logger', test_logger)
        setattr(PytestTester, 'tlib_logger', tlib_logger)
