"""
Pytest plugin with commonly used fixtures
"""
import pytest
from tlib.base import LogHelper
from tlib.base import TLibHelper

# noinspection PyShadowingNames
@pytest.fixture(scope='class')
def tlib_logger(request):
    """
    Returns logger with name tlib.\n
    This logger should only be used by TLib modules. To log from a test or test module use test_logger\n
    Logger will get flushed at the end to ensure data is not lost if tests exit abnormally
    """
    return LogHelper.get_tlib_logger(request)


# noinspection PyShadowingNames
@pytest.fixture(scope='class')
def adb_logger(request):
    """
    Returns logger with name adb\n
    This logger should only be used by TLib modules interacting with ADB.\n
    To log from a test or test module use test_logger\n
    Logger will get flushed at the end to ensure data is not lost if tests exit abnormally
    """
    return LogHelper.get_adb_logger(request)


# noinspection PyShadowingNames
@pytest.fixture(scope='class')
def test_logger(request):
    """
    Returns logger that can be used to log test information\n
    Logger will get flushed at the end to ensure data is not lost if tests exit abnormally
    """
    return LogHelper.get_test_logger(request)


def pytest_addoption(parser):
    """
    Options supported by pytest selenium plug-in
    """
    group = parser.getgroup("tlib", "General command line options provided by TLib")

    group.addoption(
        "--base_url",
        action="store",
        dest="base_url",
        help="base url of the server used for testing. This can be used for web services as well as web sites")

    group.addoption(
        "--apk_path",
        action="store",
        dest="apk_path",
        default=None,
        help="mobile app path of the mobile native app used for testing")


#noinspection PyUnresolvedReferences
# noinspection PyShadowingNames
@pytest.fixture(scope="class")
def base_url(request, tlib_logger):
    """
    Returns value of --base_url command line parameter
    """
    return TLibHelper.get_base_url(request, tlib_logger)
