/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server.model;

import io.selendroid.android.AndroidDevice;
import io.selendroid.android.HardwareDeviceListener;
import io.selendroid.exceptions.AndroidDeviceException;
import io.selendroid.exceptions.DeviceStoreException;
import io.selendroid.server.model.ActiveSession;
import io.selendroid.server.model.DeviceStore;
import io.selendroid.server.model.SelendroidStandaloneDriver;
import java.util.logging.Logger;

public class DefaultHardwareDeviceListener
implements HardwareDeviceListener {
    private static final Logger log = Logger.getLogger(DefaultHardwareDeviceListener.class.getName());
    private DeviceStore store = null;
    private SelendroidStandaloneDriver driver;

    public DefaultHardwareDeviceListener(DeviceStore store, SelendroidStandaloneDriver driver) {
        this.store = store;
        this.driver = driver;
    }

    @Override
    public void onDeviceConnected(AndroidDevice device) {
        try {
            this.store.addDevice(device);
        }
        catch (AndroidDeviceException e) {
            log.info(e.getMessage());
        }
    }

    @Override
    public void onDeviceDisconnected(AndroidDevice device) {
        try {
            ActiveSession session = this.driver.findActiveSession(device);
            if (session != null) {
                session.invalidate();
            }
            this.store.removeAndroidDevice(device);
        }
        catch (DeviceStoreException e) {
            log.severe("The device cannot be removed: " + e.getMessage());
        }
    }
}

