/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server;

import io.selendroid.SelendroidConfiguration;
import io.selendroid.exceptions.AndroidDeviceException;
import io.selendroid.exceptions.AndroidSdkException;
import io.selendroid.server.SelendroidServlet;
import io.selendroid.server.StatusServlet;
import io.selendroid.server.grid.SelfRegisteringRemote;
import io.selendroid.server.model.SelendroidStandaloneDriver;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.webbitserver.WebServer;
import org.webbitserver.WebServers;
import org.webbitserver.helpers.NamingThreadFactory;

public class SelendroidStandaloneServer {
    private static final Logger log = Logger.getLogger(SelendroidStandaloneServer.class.getName());
    private WebServer webServer;
    private SelendroidConfiguration configuration;
    private SelendroidStandaloneDriver driver = null;

    protected SelendroidStandaloneServer(SelendroidConfiguration configuration, SelendroidStandaloneDriver driver) throws AndroidSdkException {
        this.configuration = configuration;
        this.driver = driver;
        NamingThreadFactory namingThreadFactory = new NamingThreadFactory(Executors.defaultThreadFactory(), "selendroid-standalone-handler");
        this.webServer = WebServers.createWebServer(Executors.newCachedThreadPool(namingThreadFactory), new InetSocketAddress(configuration.getPort()), URI.create("http://127.0.0.1" + (configuration.getPort() == 80 ? "" : ":" + configuration.getPort()) + "/"));
        this.init();
    }

    public SelendroidStandaloneServer(SelendroidConfiguration configuration) throws AndroidSdkException, AndroidDeviceException {
        this.configuration = configuration;
        NamingThreadFactory namingThreadFactory = new NamingThreadFactory(Executors.defaultThreadFactory(), "selendroid-standalone-handler");
        this.webServer = WebServers.createWebServer(Executors.newCachedThreadPool(namingThreadFactory), new InetSocketAddress(configuration.getPort()), SelendroidStandaloneServer.remoteUri(configuration.getPort()));
        this.driver = this.initializeSelendroidServer();
        this.init();
    }

    private static URI remoteUri(int port) {
        try {
            InetAddress address = InetAddress.getByName("0.0.0.0");
            return new URI("http://" + address.getHostAddress() + (port == 80 ? "" : ":" + port) + "/");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("can not create URI from HostAddress", e);
        }
    }

    protected void init() throws AndroidSdkException {
        this.webServer.staleConnectionTimeout(this.configuration.getTimeoutEmulatorStart());
        this.webServer.add("/wd/hub/status", new StatusServlet(this.driver));
        this.webServer.add(new SelendroidServlet(this.driver, this.configuration));
    }

    protected SelendroidStandaloneDriver initializeSelendroidServer() throws AndroidSdkException, AndroidDeviceException {
        return new SelendroidStandaloneDriver(this.configuration);
    }

    public void start() {
        this.webServer.start();
        if (!StringUtils.isBlank(this.configuration.getRegistrationUrl()) && !StringUtils.isBlank(this.configuration.getServerHost())) {
            try {
                new SelfRegisteringRemote(this.configuration, this.driver).performRegistration();
            }
            catch (Exception e) {
                log.severe("An error occured while registering selendroid into grid hub.");
                e.printStackTrace();
            }
        }
        log.info("selendroid-standalone server has been started on port: " + this.configuration.getPort());
    }

    public void stop() {
        log.info("About to stop selendroid-standalone server");
        this.driver.quitSelendroid();
        this.webServer.stop();
    }

    public int getPort() {
        return this.webServer.getPort();
    }

    protected SelendroidStandaloneDriver getDriver() {
        return this.driver;
    }
}

