/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server;

import io.selendroid.SelendroidConfiguration;
import io.selendroid.server.BaseRequestHandler;
import io.selendroid.server.BaseServlet;
import io.selendroid.server.HttpResponse;
import io.selendroid.server.JsResult;
import io.selendroid.server.Response;
import io.selendroid.server.SelendroidResponse;
import io.selendroid.server.UiResponse;
import io.selendroid.server.handler.AdbExecuteShellCommand;
import io.selendroid.server.handler.AdbSendKeyEvent;
import io.selendroid.server.handler.AdbSendText;
import io.selendroid.server.handler.AdbTap;
import io.selendroid.server.handler.CaptureScreenshot;
import io.selendroid.server.handler.CreateSessionHandler;
import io.selendroid.server.handler.DeleteSessionHandler;
import io.selendroid.server.handler.GetCapabilities;
import io.selendroid.server.handler.GetLogTypes;
import io.selendroid.server.handler.GetLogs;
import io.selendroid.server.handler.InspectorScreenshotHandler;
import io.selendroid.server.handler.InspectorTreeHandler;
import io.selendroid.server.handler.InspectorUiHandler;
import io.selendroid.server.handler.ListSessionsHandler;
import io.selendroid.server.handler.RequestRedirectHandler;
import io.selendroid.server.model.SelendroidStandaloneDriver;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.webbitserver.HttpRequest;

public class SelendroidServlet
extends BaseServlet {
    private static final Logger log = Logger.getLogger(SelendroidServlet.class.getName());
    protected Map<String, BaseRequestHandler> redirectHandler = new HashMap<String, BaseRequestHandler>();
    private SelendroidStandaloneDriver driver;
    private SelendroidConfiguration conf;

    public SelendroidServlet(SelendroidStandaloneDriver driver, SelendroidConfiguration conf) {
        this.driver = driver;
        this.conf = conf;
        this.init();
    }

    @Override
    protected void init() {
        this.register(this.postHandler, new CreateSessionHandler("/wd/hub/session"));
        this.register(this.getHandler, new ListSessionsHandler("/wd/hub/sessions"));
        this.register(this.getHandler, new GetCapabilities("/wd/hub/session/:sessionId"));
        this.register(this.getHandler, new GetLogTypes("/wd/hub/session/:sessionId/log/types"));
        this.register(this.postHandler, new GetLogs("/wd/hub/session/:sessionId/log"));
        if (!this.conf.isDeviceScreenshot()) {
            this.register(this.getHandler, new CaptureScreenshot("/wd/hub/session/:sessionId/screenshot"));
        }
        this.register(this.getHandler, new InspectorTreeHandler("/inspector/session/:sessionId/tree"));
        this.register(this.getHandler, new InspectorScreenshotHandler("/inspector/session/:sessionId/screenshot"));
        this.register(this.getHandler, new InspectorUiHandler("/inspector/session/:sessionId"));
        this.register(this.deleteHandler, new DeleteSessionHandler("/wd/hub/session/:sessionId"));
        this.register(this.redirectHandler, new RequestRedirectHandler("/wd/hub/session/"));
        this.register(this.postHandler, new GetLogs("/wd/hub/session/:sessionId/log"));
        this.register(this.postHandler, new AdbSendKeyEvent("/wd/hub/-selendroid/:sessionId/adb/sendKeyEvent"));
        this.register(this.postHandler, new AdbSendText("/wd/hub/-selendroid/:sessionId/adb/sendText"));
        this.register(this.postHandler, new AdbTap("/wd/hub/-selendroid/:sessionId/adb/tap"));
        this.register(this.postHandler, new AdbExecuteShellCommand("/wd/hub/-selendroid/:sessionId/adb/executeShellCommand"));
    }

    @Override
    public void handleRequest(HttpRequest request, HttpResponse response, BaseRequestHandler foundHandler) {
        Response result;
        String sessionId;
        BaseRequestHandler handler = null;
        if ("/favicon.ico".equals(request.uri()) && foundHandler == null) {
            response.setStatus(404);
            response.end();
            return;
        }
        if ("/inspector/".equals(request.uri()) || "/inspector".equals(request.uri())) {
            if (this.driver.getActiveSessions().isEmpty()) {
                response.setStatus(200);
                response.setContent("Selendroid inspector can only be used if there is an active test session running. To start a test session, add a break point into your test code and run the test in debug mode.");
                response.end();
                return;
            }
            String session = this.driver.getActiveSessions().get(0).getSessionKey();
            String newSessionUri = "http://" + request.header("Host") + "/inspector/session/" + session + "/";
            log.info("new Inspector URL: " + newSessionUri);
            response.sendTemporaryRedirect(newSessionUri);
            response.end();
            return;
        }
        if (foundHandler == null) {
            if (!this.redirectHandler.isEmpty()) {
                for (Map.Entry<String, BaseRequestHandler> entry : this.redirectHandler.entrySet()) {
                    if (!request.uri().startsWith(entry.getKey())) continue;
                    String sessionId2 = this.getParameter("/wd/hub/session/:sessionId", request.uri(), ":sessionId", false);
                    handler = entry.getValue();
                    if (!this.driver.isValidSession(sessionId2)) continue;
                    request.data().put("SESSION_ID_KEY", sessionId2);
                }
            }
            if (handler == null) {
                response.setStatus(404);
                response.end();
                return;
            }
        } else {
            handler = foundHandler;
        }
        if ((sessionId = this.getParameter(handler.getMappedUri(), request.uri(), ":sessionId")) != null) {
            request.data().put("SESSION_ID_KEY", sessionId);
        }
        request.data().put("DRIVER_KEY", this.driver);
        try {
            result = handler.handle(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.severe("Error occurred while handling request: " + e.fillInStackTrace());
            this.replyWithServerError(response);
            return;
        }
        if (result instanceof SelendroidResponse) {
            this.handleResponse(request, response, (SelendroidResponse)result);
        } else if (result instanceof JsResult) {
            JsResult js = (JsResult)result;
            response.setContentType("application/x-javascript");
            response.setEncoding(Charset.forName("UTF-8"));
            response.setContent(js.render());
            response.end();
        } else {
            UiResponse uiResponse = (UiResponse)result;
            response.setEncoding(Charset.forName("UTF-8"));
            response.setStatus(200);
            if (uiResponse != null) {
                if (uiResponse.getObject() instanceof byte[]) {
                    response.setContentType("image/png");
                    byte[] data = (byte[])uiResponse.getObject();
                    response.setContent(data);
                } else {
                    response.setContentType("text/html");
                    String resultString = uiResponse.render();
                    response.setContent(resultString);
                }
            }
            response.end();
        }
    }
}

