/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid;

import com.google.common.collect.ImmutableMap;
import io.selendroid.AdbSupport;
import io.selendroid.Configuration;
import io.selendroid.DriverCommand;
import io.selendroid.ScreenBrightness;
import io.selendroid.SelendroidCommandExecutor;
import io.selendroid.adb.AdbConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Rotatable;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.interactions.HasTouchScreen;
import org.openqa.selenium.interactions.TouchScreen;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.RemoteExecuteMethod;
import org.openqa.selenium.remote.RemoteTouchScreen;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;

public class SelendroidDriver
extends RemoteWebDriver
implements HasTouchScreen,
ScreenBrightness,
TakesScreenshot,
Rotatable,
Configuration,
JavascriptExecutor,
AdbSupport {
    private RemoteTouchScreen touchScreen;
    private RemoteAdbConnection adbConnection;

    public SelendroidDriver(URL url, Capabilities caps) throws Exception {
        super(new SelendroidCommandExecutor(url), caps);
        this.touchScreen = new RemoteTouchScreen(new RemoteExecuteMethod(this));
    }

    public SelendroidDriver(Capabilities caps) throws Exception {
        super(new SelendroidCommandExecutor(), caps);
        RemoteExecuteMethod executeMethod = new RemoteExecuteMethod(this);
        this.touchScreen = new RemoteTouchScreen(executeMethod);
        this.adbConnection = new RemoteAdbConnection(executeMethod);
    }

    @Override
    public TouchScreen getTouch() {
        return this.touchScreen;
    }

    @Override
    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        String base64 = this.execute("screenshot").getValue().toString();
        return target.convertFromBase64Png(base64);
    }

    @Override
    public int getBrightness() {
        Response response = this.execute("selendroid-getBrightness");
        Number value = (Number)response.getValue();
        return value.intValue();
    }

    @Override
    public void setBrightness(int desiredBrightness) {
        this.execute("selendroid-setBrightness", ImmutableMap.of("brightness", desiredBrightness));
    }

    @Override
    public void rotate(ScreenOrientation orientation) {
        this.execute("setScreenOrientation", ImmutableMap.of("orientation", orientation));
    }

    @Override
    public ScreenOrientation getOrientation() {
        return ScreenOrientation.valueOf((String)this.execute("getScreenOrientation").getValue());
    }

    @Override
    public void setConfiguration(DriverCommand command, String key, Object value) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("command", command.command);
        parameters.put(key, value);
        this.execute("selendroid-setCommandConfiguration", parameters);
    }

    @Override
    public Map<String, Object> getConfiguration(DriverCommand command) {
        Response response = this.execute("selendroid-getCommandConfiguration", ImmutableMap.of("command", command.command));
        return (Map)response.getValue();
    }

    @Override
    public AdbConnection getAdbConnection() {
        return this.adbConnection;
    }

    public class RemoteAdbConnection
    implements AdbConnection {
        private final ExecuteMethod executeMethod;

        public RemoteAdbConnection(ExecuteMethod executeMethod) {
            this.executeMethod = executeMethod;
        }

        @Override
        public void tap(int x, int y) {
            HashMap<String, Integer> parameters = new HashMap<String, Integer>();
            parameters.put("x", x);
            parameters.put("y", y);
            this.executeMethod.execute("selendroid-adb-tap", parameters);
        }

        @Override
        public void sendText(String text) {
            this.executeMethod.execute("selendroid-adb-sendText", ImmutableMap.of("text", text));
        }

        @Override
        public void sendKeyEvent(int keyCode) {
            this.executeMethod.execute("selendroid-adb-sendKeyEvent", ImmutableMap.of("keyCode", keyCode));
        }

        @Override
        public void executeShellCommand(String command) {
            SelendroidDriver.this.execute("selendroid-adb-executeShellCommand", ImmutableMap.of("command", command));
        }
    }
}

