import pytest
from TestHelper import Singleton

# noinspection PyMethodParameters
# noinspection PyUnresolvedReferences
class PytestTester(object):
    __metaclass__ = Singleton

    @pytest.fixture(scope='function', autouse=True)
    def log(self, request, test_logger):
        test_logger.info("======================== START %s ========================" % request.keywords.node.name)

        def log_end():
            test_logger.info("======================== END %s ========================"  % request.keywords.node.name)

        request.addfinalizer(log_end)


    @pytest.fixture(scope='class', autouse=True)
    def initialize_pytest_class(self, request, test_logger, tlib_logger):
        """    test_logger \= None\n    tlib_logger \= None
        @type test_logger: logging
        @type tlib_logger: logging
        @type request: FixtureRequest
        """
        #Store an instance of browser and loggers to be used from code that doesn't have access to this information
        setattr(PytestTester, 'test_logger', test_logger)
        setattr(PytestTester, 'tlib_logger', tlib_logger)
