class HttpFileRequestor(object):
    """
    Helper class for retrieving http files from url 
    """

    _url = None
    _size = None
    
    def __init__(self, url=None):
        """
        Constructor for class 
        """
        self._url = url
        self._size = self.get_file_size()
        
    def get_file_size(self):
        """
        Get the size of file from the url
        """
        with urllib2.urlopen(self._url) as fd:
            info = fd.info()
        return int(info.getheader('Content-Length'))


    def tail(self, url=None, length=0):
        """
        Tail the file from the url
        """
        if url:
            self._url = url
        self._size = self.get_file_size()
        #we assume that each line may contains MAX_CHARS_IN_ONE_LINE characters at max
        start = max(0, self._size - (MAX_CHARS_IN_ONE_LINE * length))
        #send the request asking for the last n bytes of the file content from the url
        myHeaders = {'Range': 'bytes=%i-' % start}
        req = urllib2.Request(url=self._url, headers=myHeaders)
        partialFile = urllib2.urlopen(req)
        
        lines = partialFile.read().strip().split('\n')
        
        return lines[-length:] if len(lines) > length else lines[1:]
        