import os
import re


MAX_CHARS_IN_ONE_LINE = 20000

__CSL = None
def create_symlink(source, link_name):
    '''symlink(source, link_name)
       Creates a symbolic link pointing to source named link_name'''
    global __CSL
    if __CSL is None:
        import ctypes
        csl = ctypes.windll.LoadLibrary("kernel32.dll").CreateSymbolicLinkW
        csl.argtypes = (ctypes.c_wchar_p, ctypes.c_wchar_p, ctypes.c_uint32)
        csl.restype = ctypes.c_ubyte
        __CSL = csl
    flags = 0
    if source is not None and os.path.isdir(source):
        flags = 1
    if __CSL(link_name, source, flags) == 0:
        raise ctypes.WinError()

def get_filename_from_string(value):
    """
    Returns original string minus any characters that are invalid in file names
    @param value: String to convert to a valid file name
    @type value: str
    @rtype: str
    """
    return re.sub(r'[\\/:?]', '_', value)
