/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpCookie;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Date;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.util.CharsetUtil;
import org.webbitserver.HttpResponse;
import org.webbitserver.WebbitException;
import org.webbitserver.helpers.DateHelper;

public class NettyHttpResponse
implements HttpResponse {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private final ChannelHandlerContext ctx;
    private final org.jboss.netty.handler.codec.http.HttpResponse response;
    private final boolean isKeepAlive;
    private final Thread.UncaughtExceptionHandler exceptionHandler;
    private final ChannelBuffer responseBuffer;
    private Charset charset;

    public NettyHttpResponse(ChannelHandlerContext ctx, org.jboss.netty.handler.codec.http.HttpResponse response, boolean isKeepAlive, Thread.UncaughtExceptionHandler exceptionHandler) {
        this.ctx = ctx;
        this.response = response;
        this.isKeepAlive = isKeepAlive;
        this.exceptionHandler = exceptionHandler;
        this.charset = DEFAULT_CHARSET;
        this.responseBuffer = ChannelBuffers.dynamicBuffer();
    }

    @Override
    public NettyHttpResponse charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public Charset charset() {
        return this.charset;
    }

    @Override
    public NettyHttpResponse status(int status) {
        this.response.setStatus(HttpResponseStatus.valueOf(status));
        return this;
    }

    @Override
    public int status() {
        return this.response.getStatus().getCode();
    }

    @Override
    public NettyHttpResponse header(String name, String value) {
        if (value == null) {
            this.response.removeHeader(name);
        } else {
            this.response.addHeader(name, value);
        }
        return this;
    }

    @Override
    public NettyHttpResponse header(String name, long value) {
        this.response.addHeader(name, value);
        return this;
    }

    @Override
    public NettyHttpResponse header(String name, Date value) {
        this.response.addHeader(name, DateHelper.rfc1123Format(value));
        return this;
    }

    @Override
    public boolean containsHeader(String name) {
        return this.response.containsHeader(name);
    }

    @Override
    public NettyHttpResponse cookie(HttpCookie httpCookie) {
        return this.header("Set-Cookie", httpCookie.toString());
    }

    @Override
    public NettyHttpResponse content(String content) {
        return this.content(ChannelBuffers.copiedBuffer((CharSequence)content, this.charset()));
    }

    @Override
    public NettyHttpResponse content(byte[] content) {
        return this.content(ChannelBuffers.copiedBuffer(content));
    }

    @Override
    public NettyHttpResponse content(ByteBuffer buffer) {
        return this.content(ChannelBuffers.wrappedBuffer(buffer));
    }

    private NettyHttpResponse content(ChannelBuffer content) {
        this.responseBuffer.writeBytes(content);
        return this;
    }

    @Override
    public NettyHttpResponse write(String content) {
        this.write(ChannelBuffers.copiedBuffer((CharSequence)content, CharsetUtil.UTF_8));
        return this;
    }

    @Override
    public NettyHttpResponse error(Throwable error) {
        this.response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        String message = this.getStackTrace(error);
        this.header("Content-Type", "text/plain");
        this.content(message);
        this.flushResponse();
        this.exceptionHandler.uncaughtException(Thread.currentThread(), WebbitException.fromException(error, this.ctx.getChannel()));
        return this;
    }

    private String getStackTrace(Throwable error) {
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        error.printStackTrace(writer);
        writer.flush();
        return buffer.toString();
    }

    @Override
    public NettyHttpResponse end() {
        this.flushResponse();
        return this;
    }

    private void flushResponse() {
        try {
            this.header("Content-Length", (String)null);
            this.header("Content-Length", this.responseBuffer.readableBytes());
            ChannelFuture future = this.write(this.responseBuffer);
            if (!this.isKeepAlive) {
                future.addListener(ChannelFutureListener.CLOSE);
            }
        }
        catch (Exception e) {
            this.exceptionHandler.uncaughtException(Thread.currentThread(), WebbitException.fromException(e, this.ctx.getChannel()));
        }
    }

    private ChannelFuture write(ChannelBuffer responseBuffer) {
        this.response.setContent(responseBuffer);
        return this.ctx.getChannel().write(this.response);
    }
}

