/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.internal;

import java.net.ProxySelector;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class HttpClientFactory {
    private final DefaultHttpClient httpClient;
    private final int TIMEOUT_THREE_HOURS = (int)TimeUnit.SECONDS.toMillis(10800L);
    private final ClientConnectionManager gridClientConnectionManager = HttpClientFactory.getClientConnectionManager();

    public HttpClientFactory() {
        this.httpClient = new DefaultHttpClient(HttpClientFactory.getClientConnectionManager());
        this.httpClient.setParams(this.getHttpParams());
        this.httpClient.setRoutePlanner(this.getRoutePlanner(this.httpClient.getConnectionManager().getSchemeRegistry()));
    }

    private static ClientConnectionManager getClientConnectionManager() {
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, PlainSocketFactory.getSocketFactory()));
        registry.register(new Scheme("https", 443, SSLSocketFactory.getSocketFactory()));
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager(registry);
        cm.setMaxTotal(2000);
        cm.setDefaultMaxPerRoute(2000);
        return cm;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpClient getGridHttpClient(int connection_timeout, int socket_timeout) {
        DefaultHttpClient gridClient = new DefaultHttpClient(this.gridClientConnectionManager);
        gridClient.setRedirectStrategy(new MyRedirectHandler());
        gridClient.setParams(this.getGridHttpParams(connection_timeout, socket_timeout));
        gridClient.setRoutePlanner(this.getRoutePlanner(gridClient.getConnectionManager().getSchemeRegistry()));
        gridClient.getConnectionManager().closeIdleConnections(100L, TimeUnit.MILLISECONDS);
        return gridClient;
    }

    public HttpParams getHttpParams() {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setSoReuseaddr(params, true);
        HttpConnectionParams.setConnectionTimeout(params, 120000);
        HttpConnectionParams.setSoTimeout(params, this.TIMEOUT_THREE_HOURS);
        params.setIntParameter("http.connection.max-status-line-garbage", 0);
        HttpConnectionParams.setStaleCheckingEnabled(params, true);
        return params;
    }

    public HttpRoutePlanner getRoutePlanner(SchemeRegistry registry) {
        return new ProxySelectorRoutePlanner(registry, ProxySelector.getDefault());
    }

    public HttpParams getGridHttpParams(int connection_timeout, int socket_timeout) {
        HttpParams params = this.getHttpParams();
        HttpConnectionParams.setSoTimeout(params, socket_timeout > 0 ? socket_timeout : this.TIMEOUT_THREE_HOURS);
        HttpConnectionParams.setConnectionTimeout(params, connection_timeout > 0 ? connection_timeout : 120000);
        return params;
    }

    public void close() {
        this.httpClient.getConnectionManager().shutdown();
        this.gridClientConnectionManager.shutdown();
    }

    static class MyRedirectHandler
    implements RedirectStrategy {
        MyRedirectHandler() {
        }

        @Override
        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            return false;
        }

        @Override
        public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            return null;
        }
    }
}

