/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.html5;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.html5.DatabaseStorage;
import org.openqa.selenium.html5.ResultSet;
import org.openqa.selenium.html5.ResultSetRows;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.internal.WebElementToJsonConverter;

public class RemoteDatabaseStorage
implements DatabaseStorage {
    private final ExecuteMethod executeMethod;

    public RemoteDatabaseStorage(ExecuteMethod executeMethod) {
        this.executeMethod = executeMethod;
    }

    @Override
    public ResultSet executeSQL(String databaseName, String query, Object ... args) throws WebDriverException {
        query = query.replaceAll("\"", "\\\"");
        Iterable<Object> convertedArgs = Iterables.transform(Lists.newArrayList(args), new WebElementToJsonConverter());
        ImmutableMap<String, ArrayList<Object>> params = ImmutableMap.of("dbName", databaseName, "query", query, "args", Lists.newArrayList(convertedArgs));
        Map resultAsMap = (Map)this.executeMethod.execute("executeSQL", params);
        List rows = (List)resultAsMap.get("rows");
        return new ResultSet(((Number)resultAsMap.get("insertId")).intValue(), ((Number)resultAsMap.get("rowsAffected")).intValue(), new ResultSetRows(rows));
    }
}

