/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.AddFindsByCss;
import org.openqa.selenium.remote.AddFindsChildByCss;
import org.openqa.selenium.remote.AddRotatable;
import org.openqa.selenium.remote.AddTakesScreenshot;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.InterfaceImplementation;
import org.openqa.selenium.remote.RemoteExecuteMethod;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.html5.AddApplicationCache;
import org.openqa.selenium.remote.html5.AddBrowserConnection;
import org.openqa.selenium.remote.html5.AddDatabaseStorage;
import org.openqa.selenium.remote.html5.AddLocationContext;
import org.openqa.selenium.remote.html5.AddWebStorage;

public class Augmenter {
    private final Map<String, AugmenterProvider> driverAugmentors = Maps.newHashMap();
    private final Map<String, AugmenterProvider> elementAugmentors = Maps.newHashMap();

    public Augmenter() {
        this.addDriverAugmentation("cssSelectorsEnabled", new AddFindsByCss());
        this.addDriverAugmentation("takesScreenshot", new AddTakesScreenshot());
        this.addDriverAugmentation("databaseEnabled", new AddDatabaseStorage());
        this.addDriverAugmentation("locationContextEnabled", new AddLocationContext());
        this.addDriverAugmentation("applicationCacheEnabled", new AddApplicationCache());
        this.addDriverAugmentation("browserConnectionEnabled", new AddBrowserConnection());
        this.addDriverAugmentation("webStorageEnabled", new AddWebStorage());
        this.addDriverAugmentation("rotatable", new AddRotatable());
        this.addElementAugmentation("cssSelectorsEnabled", new AddFindsChildByCss());
    }

    public void addDriverAugmentation(String capabilityName, AugmenterProvider handlerClass) {
        this.driverAugmentors.put(capabilityName, handlerClass);
    }

    public void addElementAugmentation(String capabilityName, AugmenterProvider handlerClass) {
        this.elementAugmentors.put(capabilityName, handlerClass);
    }

    public WebDriver augment(WebDriver driver) {
        if (!(driver instanceof RemoteWebDriver)) {
            return driver;
        }
        Map<String, AugmenterProvider> augmentors = this.driverAugmentors;
        CompoundHandler handler = this.determineAugmentation(driver, augmentors, driver);
        RemoteWebDriver remote = this.create(handler, (RemoteWebDriver)driver);
        this.copyFields(driver.getClass(), driver, remote);
        return remote;
    }

    private void copyFields(Class<?> clazz, Object source, Object target) {
        if (Object.class.equals(clazz)) {
            return;
        }
        for (Field field : clazz.getDeclaredFields()) {
            this.copyField(source, target, field);
        }
        this.copyFields(clazz.getSuperclass(), source, target);
    }

    private void copyField(Object source, Object target, Field field) {
        if (Modifier.isFinal(field.getModifiers())) {
            return;
        }
        if (field.getName().startsWith("CGLIB$")) {
            return;
        }
        try {
            field.setAccessible(true);
            Object value = field.get(source);
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate(e);
        }
    }

    public WebElement augment(RemoteWebElement element) {
        RemoteWebDriver parent = (RemoteWebDriver)element.getWrappedDriver();
        if (parent == null) {
            return element;
        }
        Map<String, AugmenterProvider> augmentors = this.elementAugmentors;
        CompoundHandler handler = this.determineAugmentation(parent, augmentors, element);
        RemoteWebElement remote = this.create(handler, element);
        this.copyFields(element.getClass(), element, remote);
        remote.setId(element.getId());
        remote.setParent(parent);
        return remote;
    }

    private CompoundHandler determineAugmentation(WebDriver driver, Map<String, AugmenterProvider> augmentors, Object objectToAugment) {
        Map<String, ?> capabilities = ((RemoteWebDriver)driver).getCapabilities().asMap();
        CompoundHandler handler = new CompoundHandler((RemoteWebDriver)driver, objectToAugment);
        for (Map.Entry<String, ?> capabilityName : capabilities.entrySet()) {
            Object value;
            AugmenterProvider augmenter = augmentors.get(capabilityName.getKey());
            if (augmenter == null || (value = capabilityName.getValue()) instanceof Boolean && !((Boolean)value).booleanValue()) continue;
            handler.addCapabilityHander(augmenter.getDescribedInterface(), augmenter.getImplementation(value));
        }
        return handler;
    }

    protected <X> X create(CompoundHandler handler, X from) {
        if (handler.isNeedingApplication()) {
            Class<?> superClass = from.getClass();
            while (Enhancer.isEnhanced(superClass)) {
                superClass = superClass.getSuperclass();
            }
            Enhancer enhancer = new Enhancer();
            enhancer.setCallback(handler);
            enhancer.setSuperclass(superClass);
            HashSet<Class<?>> interfaces = Sets.newHashSet();
            interfaces.addAll(ImmutableList.copyOf(from.getClass().getInterfaces()));
            interfaces.addAll(handler.getInterfaces());
            enhancer.setInterfaces(interfaces.toArray(new Class[interfaces.size()]));
            return (X)enhancer.create();
        }
        return from;
    }

    private class CompoundHandler
    implements MethodInterceptor {
        private Map<Method, InterfaceImplementation> handlers = new HashMap<Method, InterfaceImplementation>();
        private Set<Class<?>> interfaces = new HashSet();
        private final RemoteWebDriver driver;
        private final Object originalInstance;

        private CompoundHandler(RemoteWebDriver driver, Object originalInstance) {
            this.driver = driver;
            this.originalInstance = originalInstance;
        }

        public void addCapabilityHander(Class<?> fromInterface, InterfaceImplementation handledBy) {
            if (fromInterface.isInterface()) {
                this.interfaces.add(fromInterface);
            }
            for (Method method : fromInterface.getDeclaredMethods()) {
                this.handlers.put(method, handledBy);
            }
        }

        public Set<Class<?>> getInterfaces() {
            return this.interfaces;
        }

        public boolean isNeedingApplication() {
            return !this.handlers.isEmpty();
        }

        @Override
        public Object intercept(Object self, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            InterfaceImplementation handler = this.handlers.get(method);
            if (handler == null) {
                try {
                    return method.invoke(this.originalInstance, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            return handler.invoke(new RemoteExecuteMethod(this.driver), self, method, args);
        }
    }
}

