/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android.library;

import com.google.common.collect.HashBiMap;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.android.library.JavascriptExecutor;
import org.openqa.selenium.android.library.JavascriptResultNotifier;
import org.openqa.selenium.android.library.ViewAdapter;

class WebDriverViewManager
implements JavascriptResultNotifier {
    private static HashBiMap<String, ViewAdapter> map = HashBiMap.create();
    private static HashBiMap<Object, ViewAdapter> views = HashBiMap.create();
    private volatile boolean done;
    private volatile String result;
    private Object syncObject = new Object();

    WebDriverViewManager() {
    }

    static ViewAdapter getViewAdapterFor(Object view) {
        return views.get(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ViewAdapter getView(String nameOrHandle) {
        Object object = this.syncObject;
        synchronized (object) {
            ViewAdapter toReturn = this.searchForViewByHandle(nameOrHandle);
            return toReturn == null ? this.searchForViewByWindowName(nameOrHandle) : toReturn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addView(ViewAdapter view) {
        Object object = this.syncObject;
        synchronized (object) {
            String u = UUID.randomUUID().toString();
            map.put(u, view);
            views.put(view.getUnderlyingView(), view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ViewAdapter getNextView() {
        Object object = this.syncObject;
        synchronized (object) {
            String key = map.keySet().iterator().next();
            return map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeView(String nameOrHandle) {
        Object object = this.syncObject;
        synchronized (object) {
            ViewAdapter toRemove = this.searchForViewByHandle(nameOrHandle);
            toRemove = toRemove != null ? toRemove : this.searchForViewByWindowName(nameOrHandle);
            this.removeView(toRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeView(ViewAdapter view) {
        Object object = this.syncObject;
        synchronized (object) {
            map.inverse().remove(view);
            views.inverse().remove(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeView(Object viewImpl) {
        Object object = this.syncObject;
        synchronized (object) {
            for (ViewAdapter adapter : map.values()) {
                if (!adapter.getClassForUnderlyingView().equals(viewImpl)) continue;
                this.removeView(adapter);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getAllHandles() {
        Object object = this.syncObject;
        synchronized (object) {
            return map.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ViewAdapter searchForViewByHandle(String handle) {
        Object object = this.syncObject;
        synchronized (object) {
            return map.get(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ViewAdapter searchForViewByWindowName(String windowName) {
        Object object = this.syncObject;
        synchronized (object) {
            for (ViewAdapter view : map.inverse().keySet()) {
                this.done = false;
                JavascriptExecutor.executeJs(view, this, "window.webdriver.resultMethod(window.name);");
                long timeout = System.currentTimeMillis() + 10000L;
                while (!this.done && System.currentTimeMillis() < timeout) {
                    try {
                        this.syncObject.wait(10000L);
                    }
                    catch (InterruptedException e) {
                        throw new WebDriverException(e);
                    }
                }
                if (this.result == null || !this.result.equals(windowName)) continue;
                return view;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getWindowHandle(ViewAdapter view) {
        Object object = this.syncObject;
        synchronized (object) {
            return (String)map.inverse().get(view);
        }
    }

    void closeAll() {
        Iterator<String> it = map.keySet().iterator();
        while (it.hasNext()) {
            String s = it.next();
            ViewAdapter viewAdapter = map.get(s);
            viewAdapter.removeAllViews();
            viewAdapter.destroy();
            views.inverse().remove(viewAdapter);
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyResultReady(String result) {
        Object object = this.syncObject;
        synchronized (object) {
            this.result = result;
            this.done = true;
            this.syncObject.notify();
        }
    }
}

