/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android.library;

import android.graphics.Picture;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.WebSettings;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.android.library.ChromeClientWrapper;
import org.openqa.selenium.android.library.ReflexionHelper;
import org.openqa.selenium.android.library.ViewClientWrapper;

public class ViewAdapter {
    private final Object view;
    private final String className;

    public ViewAdapter(String className, Object view) {
        this.view = view;
        this.className = className;
    }

    Class getClassForUnderlyingView() {
        try {
            return Class.forName(this.className);
        }
        catch (ClassNotFoundException e) {
            throw new WebDriverException("Failed to get class for underlying View with class name: " + this.className, e);
        }
    }

    public void scrollBy(int x, int y) {
        Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE};
        Object[] args = new Object[]{x, y};
        ReflexionHelper.invoke(this.view, "scrollBy", argsType, args);
    }

    public void flingScroll(int vx, int vy) {
        Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE};
        Object[] args = new Object[]{vx, vy};
        ReflexionHelper.invoke(this.view, "flingScroll", argsType, args);
    }

    public void dispatchTouchEvent(MotionEvent ev) {
        Class[] argsType = new Class[]{MotionEvent.class};
        Object[] args = new Object[]{ev};
        ReflexionHelper.invoke(this.view, "dispatchTouchEvent", argsType, args);
    }

    public float getScale() {
        Class[] argsType = new Class[]{};
        Object[] args = new Object[]{};
        return ((Float)ReflexionHelper.invoke(this.view, "getScale", argsType, args)).floatValue();
    }

    public void dispatchKeyEvent(KeyEvent event) {
        Class[] argsType = new Class[]{KeyEvent.class};
        Object[] args = new Object[]{event};
        ReflexionHelper.invoke(this.view, "dispatchKeyEvent", argsType, args);
    }

    public String getUrl() {
        Class[] argsType = new Class[]{};
        Object[] args = new Object[]{};
        return (String)ReflexionHelper.invoke(this.view, "getUrl", argsType, args);
    }

    public String getTitle() {
        Class[] argsType = new Class[]{};
        Object[] args = new Object[]{};
        return (String)ReflexionHelper.invoke(this.view, "getTitle", argsType, args);
    }

    public Picture capturePicture() {
        Class[] argsType = new Class[]{};
        Object[] args = new Object[]{};
        return (Picture)ReflexionHelper.invoke(this.view, "capturePicture", argsType, args);
    }

    public void goBack() {
        Class[] argsType = new Class[]{};
        Object[] args = new Object[]{};
        ReflexionHelper.invoke(this.view, "goBack", argsType, args);
    }

    public void goForward() {
        Class[] argsType = new Class[]{};
        Object[] args = new Object[]{};
        ReflexionHelper.invoke(this.view, "goForward", argsType, args);
    }

    public void loadUrl(String url) {
        Class[] argsType = new Class[]{String.class};
        Object[] args = new Object[]{url};
        ReflexionHelper.invoke(this.view, "loadUrl", argsType, args);
    }

    public void reload() {
        Class[] argsType = new Class[]{};
        Object[] args = new Object[]{};
        ReflexionHelper.invoke(this.view, "reload", argsType, args);
    }

    public void setNetworkAvailable(boolean networkUp) {
        Class[] argsType = new Class[]{Boolean.TYPE};
        Object[] args = new Object[]{networkUp};
        ReflexionHelper.invoke(this.view, "setNetworkAvailable", argsType, args);
    }

    public WebSettings getSettings() {
        Class[] argsType = new Class[]{};
        Object[] args = new Object[]{};
        return (WebSettings)ReflexionHelper.invoke(this.view, "getSettings", argsType, args);
    }

    public void setWebChromeClient(ChromeClientWrapper client) {
        Class[] argsType = new Class[]{client.getClassForUnderlyingClient()};
        Object[] args = new Object[]{client.getUnderlyingClient()};
        ReflexionHelper.invoke(this.view, "setWebChromeClient", argsType, args);
    }

    public void setWebViewClient(ViewClientWrapper client) {
        Class[] argsType = new Class[]{client.getClassForUnderlyingClient()};
        Object[] args = new Object[]{client.getUnderlyingClient()};
        ReflexionHelper.invoke(this.view, "setWebViewClient", argsType, args);
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener l) {
        Class[] argsType = new Class[]{View.OnFocusChangeListener.class};
        Object[] args = new Object[]{l};
        ReflexionHelper.invoke(this.view, "setOnFocusChangeListener", argsType, args);
    }

    public void addJavascriptInterface(Object obj, String interfaceName) {
        Class[] argsType = new Class[]{Object.class, String.class};
        Object[] args = new Object[]{obj, interfaceName};
        ReflexionHelper.invoke(this.view, "addJavascriptInterface", argsType, args);
    }

    public void clearCache(boolean includeDiskFiles) {
        Class[] argsType = new Class[]{Boolean.TYPE};
        Object[] args = new Object[]{includeDiskFiles};
        ReflexionHelper.invoke(this.view, "clearCache", argsType, args);
    }

    public void clearFormData() {
        Class[] argsType = new Class[]{};
        Object[] args = new Object[]{};
        ReflexionHelper.invoke(this.view, "clearFormData", argsType, args);
    }

    public void clearHistory() {
        Class[] argsType = new Class[]{};
        Object[] args = new Object[]{};
        ReflexionHelper.invoke(this.view, "clearHistory", argsType, args);
    }

    public void clearView() {
        Class[] argsType = new Class[]{};
        Object[] args = new Object[]{};
        ReflexionHelper.invoke(this.view, "clearView", argsType, args);
    }

    public boolean requestFocus(int direction) {
        Class[] argsType = new Class[]{Integer.TYPE};
        Object[] args = new Object[]{direction};
        return (Boolean)ReflexionHelper.invoke(this.view, "requestFocus", argsType, args);
    }

    public void setFocusable(boolean focusable) {
        Class[] argsType = new Class[]{Boolean.TYPE};
        Object[] args = new Object[]{focusable};
        ReflexionHelper.invoke(this.view, "setFocusable", argsType, args);
    }

    public void setFocusableInTouchMode(boolean focusableInTouchMode) {
        Class[] argsType = new Class[]{Boolean.TYPE};
        Object[] args = new Object[]{focusableInTouchMode};
        ReflexionHelper.invoke(this.view, "setFocusableInTouchMode", argsType, args);
    }

    public Object getUnderlyingView() {
        return this.view;
    }

    public void removeAllViews() {
        Class[] argsType = new Class[]{};
        Object[] args = new Object[]{};
        ReflexionHelper.invoke(this.view, "removeAllViews", argsType, args);
    }

    public void destroy() {
        Class[] argsType = new Class[]{};
        Object[] args = new Object[]{};
        ReflexionHelper.invoke(this.view, "destroy", argsType, args);
    }
}

