/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android.library;

import android.app.Activity;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.webkit.WebView;
import java.util.List;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.android.library.AndroidKeys;

class EventSender {
    private static MotionEvent lastSent;
    private static final Object syncObject;
    private static volatile boolean done;

    EventSender() {
    }

    static MotionEvent getLastEvent() {
        return lastSent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sendMotion(final List<MotionEvent> events, final WebView view, Activity activity) {
        long timeout = System.currentTimeMillis() + 10000L;
        Object object = syncObject;
        synchronized (object) {
            lastSent = events.get(events.size() - 1);
            done = false;
            activity.runOnUiThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    float zoom = view.getScale();
                    for (MotionEvent event : events) {
                        event.setLocation(zoom * event.getX(), zoom * event.getY());
                        try {
                            event.setSource(2);
                        }
                        catch (NoSuchMethodError e) {
                            throw new WebDriverException("You are using an Android WebDriver APK for ICS SDKs or more recent SDK versions. For more info see http://code.google.com/p/selenium/wiki/AndroidDriver#Supported_Platforms.", e);
                        }
                        view.dispatchTouchEvent(event);
                        Object object = syncObject;
                        synchronized (object) {
                            done = true;
                            syncObject.notify();
                        }
                    }
                }
            });
            EventSender.waitForNotification(timeout, "Failed to send motion events.");
        }
    }

    private static void waitForNotification(long timeout, String errorMsg) {
        while (!done && System.currentTimeMillis() < timeout) {
            try {
                syncObject.wait(10000L);
            }
            catch (InterruptedException e) {
                throw new WebDriverException(errorMsg, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sendKeys(final WebView webview, Activity activity, final CharSequence ... text) {
        final KeyCharacterMap characterMap = KeyCharacterMap.load((int)-1);
        long timeout = System.currentTimeMillis() + 10000L;
        Object object = syncObject;
        synchronized (object) {
            done = false;
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    for (CharSequence sequence : text) {
                        for (int i = 0; i < sequence.length(); ++i) {
                            char c = sequence.charAt(i);
                            int code = AndroidKeys.getKeyEventFromUnicodeKey(c);
                            if (code != -1) {
                                webview.dispatchKeyEvent(new KeyEvent(0, code));
                                webview.dispatchKeyEvent(new KeyEvent(1, code));
                                continue;
                            }
                            KeyEvent[] arr = characterMap.getEvents(new char[]{c});
                            if (arr == null) continue;
                            for (int j = 0; j < arr.length; ++j) {
                                webview.dispatchKeyEvent(arr[j]);
                            }
                        }
                    }
                    done = true;
                    syncObject.notify();
                }
            });
        }
        EventSender.waitForNotification(timeout, "Failed to send keys.");
    }

    static {
        syncObject = new Object();
    }
}

