/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android.library;

import android.os.SystemClock;
import android.view.MotionEvent;
import android.webkit.WebView;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.android.library.AndroidAtoms;
import org.openqa.selenium.android.library.AndroidCoordinates;
import org.openqa.selenium.android.library.AndroidWebDriver;
import org.openqa.selenium.android.library.EventSender;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.internal.WrapsElement;

public class AndroidWebElement
implements WebElement,
SearchContext,
WrapsDriver,
Locatable {
    private final AndroidWebDriver driver;
    private final String elementId;
    private AndroidCoordinates coordinates;
    private FindByImpl findsBy;
    private static final String LOCATOR_ID = "id";
    private static final String LOCATOR_LINK_TEXT = "linkText";
    private static final String LOCATOR_PARTIAL_LINK_TEXT = "partialLinkText";
    private static final String LOCATOR_NAME = "name";
    private static final String LOCATOR_TAG_NAME = "tagName";
    private static final String LOCATOR_XPATH = "xpath";
    private static final String LOCATOR_CSS_SELECTOR = "css";
    private static final String LOCATOR_CLASS_NAME = "className";

    AndroidWebElement(AndroidWebDriver driver, String elementId) {
        this.driver = driver;
        this.elementId = elementId;
        this.findsBy = new FindByImpl();
    }

    String getId() {
        return this.elementId;
    }

    public boolean equals(Object o) {
        if (!(o instanceof WebElement)) {
            return false;
        }
        WebElement e = (WebElement)o;
        if (e instanceof WrapsElement) {
            e = ((WrapsElement)o).getWrappedElement();
        }
        if (!(e instanceof AndroidWebElement)) {
            return false;
        }
        return this.elementId.equals(((AndroidWebElement)e).getId());
    }

    public int hashCode() {
        return this.elementId.hashCode();
    }

    private Point getCenterCoordinates() {
        if (!this.isDisplayed()) {
            throw new ElementNotVisibleException("This WebElement is not visisble and may not be clicked.");
        }
        this.driver.setEditAreaHasFocus(false);
        Point topLeft = this.getLocation();
        String sizeJs = "var __webdriver_w = 0;var __webdriver_h = 0;if (arguments[0].getClientRects && arguments[0].getClientRects()[0]) {  __webdriver_w = arguments[0].getClientRects()[0].width;  __webdriver_h = arguments[0].getClientRects()[0].height; } else {  __webdriver_w = arguments[0].offsetWidth;  __webdriver_h = arguments[0].offsetHeight;}; return __webdriver_w + ',' + __webdriver_h;";
        String[] result = ((String)this.driver.executeScript(sizeJs, this)).split(",");
        return new Point(topLeft.x + Integer.parseInt(result[0]) / 2, topLeft.y + Integer.parseInt(result[1]) / 2);
    }

    @Override
    public void click() {
        if ("OPTION".equals(this.getTagName().toUpperCase())) {
            this.driver.resetPageIsLoading();
            this.driver.executeAtom(AndroidAtoms.CLICK.getValue(), this);
            this.driver.waitForPageToLoad();
        }
        Point center = this.getCenterCoordinates();
        long downTime = SystemClock.uptimeMillis();
        ArrayList<MotionEvent> events = Lists.newArrayList();
        MotionEvent downEvent = MotionEvent.obtain((long)downTime, (long)SystemClock.uptimeMillis(), (int)0, (float)center.x, (float)center.y, (int)0);
        events.add(downEvent);
        MotionEvent upEvent = MotionEvent.obtain((long)downTime, (long)SystemClock.uptimeMillis(), (int)1, (float)center.x, (float)center.y, (int)0);
        events.add(upEvent);
        this.driver.resetPageIsLoading();
        EventSender.sendMotion(events, this.driver.getWebView(), this.driver.getActivity());
        this.driver.waitForPageToLoad();
    }

    @Override
    public void submit() {
        String tagName = this.getTagName();
        if ("button".equalsIgnoreCase(tagName) || "submit".equalsIgnoreCase(this.getAttribute("type")) || "img".equalsIgnoreCase(tagName)) {
            this.click();
        } else {
            this.driver.resetPageIsLoading();
            this.driver.executeAtom(AndroidAtoms.SUBMIT.getValue(), this);
            this.driver.waitForPageToLoad();
        }
    }

    @Override
    public void clear() {
        this.driver.executeAtom(AndroidAtoms.CLEAR.getValue(), this);
    }

    @Override
    public void sendKeys(final CharSequence ... value) {
        if (value == null || value.length == 0) {
            return;
        }
        if (!this.isEnabled()) {
            throw new InvalidElementStateException("Cannot send keys to disabled element.");
        }
        this.click();
        this.driver.waitUntilEditAreaHasFocus();
        this.driver.executeScript("arguments[0].focus();arguments[0].value=arguments[0].value;", this);
        final WebView view = this.driver.getWebView();
        final Semaphore sem = new Semaphore(0);
        this.driver.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                EventSender.sendKeys(view, AndroidWebElement.this.driver.getActivity(), value);
                sem.release();
            }
        });
        try {
            sem.tryAcquire(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new WebDriverException("Error while sending keys.", e);
        }
    }

    @Override
    public String getTagName() {
        String tagName = (String)this.driver.executeScript("return arguments[0].tagName", this);
        return tagName.toLowerCase();
    }

    @Override
    public String getAttribute(String name) {
        return (String)this.driver.executeAtom(AndroidAtoms.GET_ATTRIBUTE_VALUE.getValue(), this, name);
    }

    @Override
    public boolean isSelected() {
        return (Boolean)this.driver.executeAtom(AndroidAtoms.IS_SELECTED.getValue(), this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)this.driver.executeAtom(AndroidAtoms.IS_ENABLED.getValue(), this);
    }

    @Override
    public String getText() {
        return (String)this.driver.executeAtom(AndroidAtoms.GET_TEXT.getValue(), this);
    }

    @Override
    public WebElement findElement(By by) {
        return by.findElement(this.findsBy);
    }

    @Override
    public List<WebElement> findElements(By by) {
        return by.findElements(this.findsBy);
    }

    FindByImpl getFinder() {
        return this.findsBy;
    }

    private List<WebElement> lookupElements(String strategy, String locator) {
        List<WebElement> results;
        try {
            results = this.elementId.equals("") ? (List)this.driver.executeAtom(AndroidAtoms.FIND_ELEMENTS.getValue(), strategy, locator) : (List)this.driver.executeAtom(AndroidAtoms.FIND_ELEMENTS.getValue(), strategy, locator, this);
        }
        catch (RuntimeException e) {
            results = Lists.newArrayList();
        }
        if (results == null) {
            return Lists.newArrayList();
        }
        return results;
    }

    private WebElement lookupElement(String strategy, String locator) {
        WebElement el = this.elementId.equals("") ? (WebElement)this.driver.executeAtom(AndroidAtoms.FIND_ELEMENT.getValue(), strategy, locator) : (WebElement)this.driver.executeAtom(AndroidAtoms.FIND_ELEMENT.getValue(), strategy, locator, this);
        if (el == null) {
            throw new NoSuchElementException("Could not find element with " + strategy + ": " + locator);
        }
        return el;
    }

    public void dragAndDropBy(int moveRightBy, int moveDownBy) {
        throw new UnsupportedOperationException("Action not supported.");
    }

    public void dragAndDropOn(AndroidWebElement element) {
        throw new UnsupportedOperationException("Action not supported.");
    }

    @Override
    public Point getLocation() {
        Map map = (Map)this.driver.executeAtom(AndroidAtoms.GET_TOP_LEFT_COORDINATES.getValue(), this);
        return new Point(((Long)map.get("x")).intValue(), ((Long)map.get("y")).intValue());
    }

    @Override
    public Dimension getSize() {
        Map map = (Map)this.driver.executeAtom(AndroidAtoms.GET_SIZE.getValue(), this);
        return new Dimension(((Long)map.get("width")).intValue(), ((Long)map.get("height")).intValue());
    }

    public String getValueOfCssProperty(String property) {
        return (String)this.driver.executeAtom(AndroidAtoms.GET_VALUE_OF_CSS_PROPERTY.getValue(), this, property);
    }

    public void hover() {
        throw new UnsupportedOperationException("Android does not support hover event");
    }

    @Override
    public boolean isDisplayed() {
        return (Boolean)this.driver.executeAtom(AndroidAtoms.IS_DISPLAYED.getValue(), this);
    }

    @Override
    public WebDriver getWrappedDriver() {
        return this.driver;
    }

    @Override
    public String getCssValue(String propertyName) {
        throw new UnsupportedOperationException("Getting CSS values is not supported yet.");
    }

    @Override
    public Coordinates getCoordinates() {
        if (this.coordinates == null) {
            this.coordinates = new AndroidCoordinates(this.elementId, this.elementId.equals("0") ? new Point(0, 0) : this.getCenterCoordinates());
        }
        return this.coordinates;
    }

    class FindByImpl
    implements SearchContext,
    FindsById,
    FindsByLinkText,
    FindsByXPath,
    FindsByTagName,
    FindsByCssSelector,
    FindsByClassName {
        FindByImpl() {
        }

        @Override
        public WebElement findElement(By by) {
            return by.findElement(AndroidWebElement.this.findsBy);
        }

        @Override
        public List<WebElement> findElements(By by) {
            return by.findElements(AndroidWebElement.this.findsBy);
        }

        @Override
        public WebElement findElementById(String using) {
            return AndroidWebElement.this.lookupElement(AndroidWebElement.LOCATOR_ID, using);
        }

        @Override
        public List<WebElement> findElementsById(String using) {
            return AndroidWebElement.this.lookupElements(AndroidWebElement.LOCATOR_ID, using);
        }

        @Override
        public WebElement findElementByXPath(String using) {
            return AndroidWebElement.this.lookupElement(AndroidWebElement.LOCATOR_XPATH, using);
        }

        @Override
        public List<WebElement> findElementsByXPath(String using) {
            return AndroidWebElement.this.lookupElements(AndroidWebElement.LOCATOR_XPATH, using);
        }

        @Override
        public WebElement findElementByLinkText(String using) {
            return AndroidWebElement.this.lookupElement(AndroidWebElement.LOCATOR_LINK_TEXT, using);
        }

        @Override
        public List<WebElement> findElementsByLinkText(String using) {
            return AndroidWebElement.this.lookupElements(AndroidWebElement.LOCATOR_LINK_TEXT, using);
        }

        @Override
        public WebElement findElementByPartialLinkText(String using) {
            return AndroidWebElement.this.lookupElement(AndroidWebElement.LOCATOR_PARTIAL_LINK_TEXT, using);
        }

        @Override
        public List<WebElement> findElementsByPartialLinkText(String using) {
            return AndroidWebElement.this.lookupElements(AndroidWebElement.LOCATOR_PARTIAL_LINK_TEXT, using);
        }

        @Override
        public WebElement findElementByTagName(String using) {
            return AndroidWebElement.this.lookupElement(AndroidWebElement.LOCATOR_TAG_NAME, using);
        }

        @Override
        public List<WebElement> findElementsByTagName(String using) {
            return AndroidWebElement.this.lookupElements(AndroidWebElement.LOCATOR_TAG_NAME, using);
        }

        public WebElement findElementByName(String using) {
            return AndroidWebElement.this.lookupElement(AndroidWebElement.LOCATOR_NAME, using);
        }

        public List<WebElement> findElementsByName(String using) {
            return AndroidWebElement.this.lookupElements(AndroidWebElement.LOCATOR_NAME, using);
        }

        @Override
        public WebElement findElementByCssSelector(String using) {
            return AndroidWebElement.this.lookupElement(AndroidWebElement.LOCATOR_CSS_SELECTOR, using);
        }

        @Override
        public List<WebElement> findElementsByCssSelector(String using) {
            return AndroidWebElement.this.lookupElements(AndroidWebElement.LOCATOR_CSS_SELECTOR, using);
        }

        @Override
        public WebElement findElementByClassName(String using) {
            return AndroidWebElement.this.lookupElement(AndroidWebElement.LOCATOR_CLASS_NAME, using);
        }

        @Override
        public List<WebElement> findElementsByClassName(String using) {
            return AndroidWebElement.this.lookupElements(AndroidWebElement.LOCATOR_CLASS_NAME, using);
        }
    }
}

