/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.waiter;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class TestWaiter {
    private static final long DEFAULT_TIME_OUT = 10L;
    private static final TimeUnit DEFAULT_UNIT = TimeUnit.SECONDS;

    public static <X> X waitFor(Callable<X> until) {
        return TestWaiter.waitFor(until, 10L, DEFAULT_UNIT);
    }

    public static <X> X waitFor(Callable<X> until, long duration, TimeUnit in) {
        long end = System.currentTimeMillis() + in.toMillis(duration);
        X value = null;
        Exception lastException = null;
        while (System.currentTimeMillis() < end) {
            try {
                value = until.call();
                if (value instanceof Boolean ? (Boolean)value != false : value != null) {
                    return value;
                }
                TestWaiter.sleep(100L);
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw TestWaiter.propagate(lastException);
        }
        throw new RuntimeException("Condition timed out: " + until);
    }

    private static RuntimeException propagate(Exception lastException) {
        if (lastException instanceof RuntimeException) {
            throw (RuntimeException)lastException;
        }
        throw new RuntimeException(lastException);
    }

    private static void sleep(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static WebElement waitForElement(By by, int timeout, WebDriver driver) {
        WebDriverWait wait = new WebDriverWait(driver, timeout);
        WebElement element = (WebElement)wait.until(ExpectedConditions.presenceOfElementLocated(by));
        return element;
    }
}

