/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server.handler;

import io.selendroid.server.BaseSelendroidServerHandler;
import io.selendroid.server.Response;
import io.selendroid.server.SelendroidResponse;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.webbitserver.HttpRequest;

public class CreateSessionHandler
extends BaseSelendroidServerHandler {
    private static final Logger log = Logger.getLogger(CreateSessionHandler.class.getName());

    public CreateSessionHandler(String mappedUri) {
        super(mappedUri);
    }

    @Override
    public Response handle(HttpRequest request) throws JSONException {
        String sessionID;
        JSONObject payload = this.getPayload(request);
        log.info("new session command with capabilities: " + payload.toString(2));
        JSONObject desiredCapabilities = payload.getJSONObject("desiredCapabilities");
        try {
            sessionID = this.getSelendroidDriver(request).createNewTestSession(desiredCapabilities, 5);
        }
        catch (Exception e) {
            log.severe("Error while creating new session: " + e.getMessage());
            e.printStackTrace();
            return new SelendroidResponse("", 33, e);
        }
        return new SelendroidResponse(sessionID, 0, desiredCapabilities);
    }
}

