/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.device;

public enum DeviceTargetPlatform {
    ANDROID10("2.3.3"),
    ANDROID11("3.0"),
    ANDROID12("3.1"),
    ANDROID13("3.2"),
    ANDROID14("4.0"),
    ANDROID15("4.0.3"),
    ANDROID16("4.1.2"),
    ANDROID17("4.2.2"),
    ANDROID18("4.3"),
    ANDROID19("4.4");

    public static final String ANDROID = "ANDROID";
    private String versionNumber;
    private String api;

    private DeviceTargetPlatform(String version) {
        this.versionNumber = version;
        this.api = this.name().replace(ANDROID, "");
    }

    public String getSdkFolderName() {
        return this.name().replace(ANDROID, "android-");
    }

    public static DeviceTargetPlatform fromPlatformVersion(String text) {
        if (text != null) {
            for (DeviceTargetPlatform b : DeviceTargetPlatform.values()) {
                if (!b.name().equals(ANDROID + text) && !b.name().equals(text)) continue;
                return b;
            }
        }
        return null;
    }

    public static DeviceTargetPlatform fromInt(String text) {
        if (text != null) {
            for (DeviceTargetPlatform b : DeviceTargetPlatform.values()) {
                if (!b.name().equals(ANDROID + text)) continue;
                return b;
            }
        }
        return null;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public String getApi() {
        return this.api;
    }
}

