/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.android.impl;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.RawImage;
import io.selendroid.android.impl.AbstractDevice;
import io.selendroid.device.DeviceTargetPlatform;
import java.util.Locale;
import java.util.logging.Logger;

public class DefaultHardwareDevice
extends AbstractDevice {
    private static final Logger log = Logger.getLogger(DefaultHardwareDevice.class.getName());
    private String model = null;
    private Locale locale = null;
    private DeviceTargetPlatform targetPlatform = null;
    private String screenSize = null;

    public DefaultHardwareDevice(IDevice device) {
        super(device);
    }

    public String getModel() {
        if (this.model == null) {
            this.model = this.getProp("ro.product.model");
        }
        return this.model;
    }

    @Override
    protected String getProp(String key) {
        return this.device.getProperty(key);
    }

    @Override
    public DeviceTargetPlatform getTargetPlatform() {
        if (this.targetPlatform == null) {
            String version = this.getProp("ro.build.version.sdk");
            this.targetPlatform = DeviceTargetPlatform.fromInt(version);
        }
        return this.targetPlatform;
    }

    @Override
    public String getScreenSize() {
        if (this.screenSize == null) {
            RawImage screeshot = null;
            try {
                screeshot = this.device.getScreenshot();
                this.screenSize = screeshot.height + "x" + screeshot.width;
            }
            catch (Exception e) {
                log.warning("was not able to determine screensize: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return this.screenSize;
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = new Locale(this.getProp("persist.sys.language"), this.getProp("persist.sys.country"));
        }
        return this.locale;
    }

    @Override
    public boolean isDeviceReady() {
        return true;
    }

    public String toString() {
        return "HardwareDevice [serial=" + this.serial + ", model=" + this.getModel() + ", targetVersion=" + (Object)((Object)this.getTargetPlatform()) + "]";
    }

    @Override
    public String getSerial() {
        return this.serial;
    }
}

