/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.android;

import io.selendroid.android.OS;
import io.selendroid.exceptions.AndroidSdkException;
import io.selendroid.exceptions.SelendroidException;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collections;

public class AndroidSdk {
    public static final String ANDROID_FOLDER_PREFIX = "android-";
    public static final String ANDROID_HOME = "ANDROID_HOME";

    public static File adb() {
        return new File(AndroidSdk.platformToolsHome(), "adb" + OS.platformExecutableSuffixExe());
    }

    public static File aapt() throws AndroidSdkException {
        StringBuffer command = new StringBuffer();
        command.append("aapt");
        command.append(OS.platformExecutableSuffixExe());
        File platformToolsAapt = new File(AndroidSdk.platformToolsHome(), command.toString());
        if (platformToolsAapt.isFile()) {
            return platformToolsAapt;
        }
        File buildToolsFolder = AndroidSdk.buildToolsHome();
        return new File(AndroidSdk.findLatestAndroidPlatformFolder(buildToolsFolder, "Command 'aapt' was not found inside the Android SDK. Please update to the latest development tools and try again."), command.toString());
    }

    public static File android() {
        StringBuffer command = new StringBuffer();
        command.append(AndroidSdk.toolsHome());
        return new File(AndroidSdk.toolsHome(), "android" + OS.platformExecutableSuffixBat());
    }

    public static File emulator() {
        return new File(AndroidSdk.toolsHome(), "emulator" + OS.platformExecutableSuffixExe());
    }

    private static File toolsHome() {
        StringBuffer command = new StringBuffer();
        command.append(AndroidSdk.androidHome());
        command.append(File.separator);
        command.append("tools");
        command.append(File.separator);
        return new File(command.toString());
    }

    private static File buildToolsHome() {
        StringBuffer command = new StringBuffer();
        command.append(AndroidSdk.androidHome());
        command.append(File.separator);
        command.append("build-tools");
        command.append(File.separator);
        return new File(command.toString());
    }

    private static File platformToolsHome() {
        StringBuffer command = new StringBuffer();
        command.append(AndroidSdk.androidHome());
        command.append(File.separator);
        command.append("platform-tools");
        command.append(File.separator);
        return new File(command.toString());
    }

    public static String androidHome() {
        String androidHome = System.getenv(ANDROID_HOME);
        if (androidHome == null) {
            throw new SelendroidException("Environment variable 'ANDROID_HOME' was not found!");
        }
        return androidHome;
    }

    public static String androidJar() {
        String platformsRootFolder = AndroidSdk.androidHome() + File.separator + "platforms";
        File platformsFolder = new File(platformsRootFolder);
        return new File(AndroidSdk.findLatestAndroidPlatformFolder(platformsFolder, "No installed Android APIs have been found."), "android.jar").getAbsolutePath();
    }

    protected static File findLatestAndroidPlatformFolder(File rootFolder, String errorMessage) {
        File[] androidApis = rootFolder.listFiles(new AndroidFileFilter());
        if (androidApis == null || androidApis.length == 0) {
            throw new SelendroidException(errorMessage);
        }
        Arrays.sort(androidApis, Collections.reverseOrder());
        return androidApis[0].getAbsoluteFile();
    }

    public static class AndroidFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            String regex;
            String fileName = pathname.getName();
            return fileName.matches(regex = "\\d{2}\\.\\d{1}\\.\\d{1}") || fileName.startsWith(AndroidSdk.ANDROID_FOLDER_PREFIX);
        }
    }
}

