import warnings
import pytest

def deprecated(func):
     '''Functioa that can be used to mark functions as deprecated. It will result in a warning being emitted
     when the function is used.\n
     To use it mark function with @deprecated decorator'''
     def new_func(*args, **kwargs):
         warnings.warn("Call to deprecated function {}.".format(func.__name__),
                       category=DeprecationWarning)
         return func(*args, **kwargs)
     new_func.__name__ = func.__name__
     new_func.__doc__ = func.__doc__
     new_func.__dict__.update(func.__dict__)
     return new_func


def get_base_url(request, tlib_logger):
    """
    Returns value of --base_url command line parameter
    """
    if request.config.getoption("base_url") is None:
        #noinspection PyUnresolvedReferences
        tlib_logger.warn("parameter --base_url was not specified")
        raise RuntimeError("parameter --base_url was not specified")
        return None
    else:
        return request.config.getoption("base_url")

