# noinspection PyPackageRequirements
import pytest
# noinspection PyPackageRequirements
from selenium import webdriver
# noinspection PyPackageRequirements
from WebDriverTester import WebDriverTester
from TestHelper import Singleton
import time


# noinspection PyMethodParameters
# noinspection PyUnresolvedReferences
class SelendroidTester(WebDriverTester):
    __metaclass__ = Singleton
    def _get_driver(self):
        """
        Returns Instance of the WebDriver remote driver
        @rtype: webdriver.Remote
        """
        return self._driver

    def _set_driver(self, driver):
        """
        Instance of the WebDriver remote driver
        @type driver: webdriver.Remote
        """
        self._driver = driver

    driver = property(_get_driver, _set_driver)


    @pytest.fixture(scope='function', autouse=True)
    def setup_selendroid_test(self, request, test_logger, driver):
        """
        Launch the application on mobile device for each test case, unless marker skipsetup is given
        """
        if not request.node.function.__dict__.has_key('skipsetup'):
            pass
        else:
            test_logger.info("Skipping setup")
        self.driver = driver

    def wait_for_page_loaded(self, timeout=10):
        """
        Waist until document.readyState is equal to complete
        @type timeout: Integer
        @param timeout: Number of seconds before timing out
        """
        #TODO:
        # Find a proper way to see if the app is loaded or not
        time.sleep(1.0)
        pass

        self.tlib_logger.debug("Page '%s' finished loading" % self._driver.current_url)
