import pytest
import sys
from TestHelper import Singleton
import ctypes

# noinspection PyMethodParameters
# noinspection PyUnresolvedReferences
class PytestTester(object):
    __metaclass__ = Singleton
    test_logger = None
    tlib_logger = None

    @pytest.fixture(scope='function', autouse=True)
    def log(self, request, test_logger):
        test_logger.info("======================== START %s ========================" % request.keywords.node.name)

        def log_end():
            test_logger.info("======================== END %s ========================" % request.keywords.node.name)

        request.addfinalizer(log_end)

    # noinspection PyPep8Naming
    @pytest.fixture(scope='class', autouse=True)
    def initialize_PytestTester_class(self, request, test_logger, tlib_logger):
        """
        @type request: FixtureRequest
        @type test_logger: logging
        @type tlib_logger: logging
        """
        #Store an instance of browser and loggers to be used from code that doesn't have access to this information
        setattr(PytestTester, 'test_logger', test_logger)
        setattr(PytestTester, 'tlib_logger', tlib_logger)

    @pytest.fixture()
    def ignore_windows_GPF_dialog(self):
        """
        Ignores the GPF dialog when a windows application crashes so that the test can continue when
            the intention is that the application crashes
        """
        if sys.platform.startswith("win"):
            # Don't display the Windows GPF dialog if the invoked program dies.
            SEM_NOGPFAULTERRORBOX = 0x0002 # From MSDN
            ctypes.windll.kernel32.SetErrorMode(SEM_NOGPFAULTERRORBOX);
            subprocess_flags = 0x8000000 #win32con.CREATE_NO_WINDOW?
        else:
            subprocess_flags = 0
