import os
import logging
import logging.config
from logging import Formatter
from tlib.base import TestHelper


def get_tlib_logger(request=None):
    """
    Returns logger named tlib.\n
    This logger should only be used by TLib modules. To log from a test or test module use get_test_logger\n
    Logger will get flushed at the end to ensure data is not lost if tests exits abnormally
    :param request
    """
    if request is None:
        return get_logger(os.path.abspath(os.curdir), "tlib")
    else:
        return get_logger(request.fspath.strpath, "tlib")


def get_adb_logger(request=None):
    """
    Returns logger named adb.\n
    This logger should only be used by adb modules. To log from a test or test module use get_test_logger\n
    Logger will get flushed at the end to ensure data is not lost if tests exits abnormally
    """
    if request is None:
        return get_logger(os.path.abspath(os.curdir), "adb")
    else:
        return get_logger(request.fspath.strpath, "adb")

def get_test_logger(request=None):
    """
    Returns logger named test.\n
    This logger should only be used by test modules. To log from a test or test module use get_test_logger\n
    Logger will get flushed at the end to ensure data is not lost if tests exits abnormally
    """
    if request is None:
        return get_logger(os.path.abspath(os.curdir), "test")
    else:
        return get_logger(request.fspath.strpath, "test")

def get_logger(path, name):
    """
    Returns a logger that has a console and a file handler.\n

    @param name: Logger to return
    @type name: str
    @return:
    """
    # find location of .log file
    #Go up to three levels to find log folder. Search starts in current directory
    log_folder = None
    for i in range(1, 5):
        path = os.path.abspath(os.path.join(path, os.pardir))

        #Check if there is a folder 'logs'
        folder = os.path.join(path, 'logs')
        if os.path.exists(folder):
            log_folder = folder
            break

    if log_folder is None:
        raise IOError("Couldn't find folder 'logs'. Create it under your project folder and try again")

    #Create logger
    logger = logging.getLogger(name)
    logger.setLevel(logging.DEBUG)

    #Add a file handler
    fh = logging.FileHandler(os.path.join(log_folder, 'test.log'))
    logger.addHandler(fh)
    logger.propagate = 0

    fh.setLevel(logging.DEBUG)

    #Set log format
    formatter = Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
    fh.setFormatter(formatter)

    return logger