/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.logging.LocalLogs;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.NeedsLocalLogs;
import org.openqa.selenium.logging.profiler.HttpProfilerLogEntry;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.HttpVerb;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionNotFoundException;
import org.openqa.selenium.remote.internal.HttpClientFactory;

public class HttpCommandExecutor
implements CommandExecutor,
NeedsLocalLogs {
    private static final int MAX_REDIRECTS = 10;
    private final HttpHost targetHost;
    private final URL remoteServer;
    private final Map<String, CommandInfo> nameToUrl;
    private final HttpClient client;
    private final ErrorCodes errorCodes = new ErrorCodes();
    private static HttpClientFactory httpClientFactory;
    private LocalLogs logs = LocalLogs.getNullLogger();

    public HttpCommandExecutor(URL addressOfRemoteServer) {
        this(ImmutableMap.of(), addressOfRemoteServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer) {
        try {
            this.remoteServer = addressOfRemoteServer == null ? new URL(System.getProperty("webdriver.remote.server", "http://localhost:4444/wd/hub")) : addressOfRemoteServer;
        }
        catch (MalformedURLException e) {
            throw new WebDriverException(e);
        }
        BasicHttpParams params = new BasicHttpParams();
        params.setParameter("http.socket.linger", -1);
        HttpClientParams.setRedirecting(params, false);
        Class<HttpCommandExecutor> clazz = HttpCommandExecutor.class;
        synchronized (HttpCommandExecutor.class) {
            if (httpClientFactory == null) {
                httpClientFactory = new HttpClientFactory();
            }
            // ** MonitorExit[var4_5] (shouldn't be in output)
            this.client = httpClientFactory.getHttpClient();
            if (addressOfRemoteServer != null && addressOfRemoteServer.getUserInfo() != null) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(addressOfRemoteServer.getUserInfo());
                ((DefaultHttpClient)this.client).getCredentialsProvider().setCredentials(AuthScope.ANY, credentials);
            }
            String host = this.remoteServer.getHost().replace(".localdomain", "");
            this.targetHost = new HttpHost(host, this.remoteServer.getPort(), this.remoteServer.getProtocol());
            ImmutableMap.Builder<String, CommandInfo> builder = ImmutableMap.builder();
            for (Map.Entry<String, CommandInfo> entry : additionalCommands.entrySet()) {
                builder.put(entry.getKey(), entry.getValue());
            }
            builder.put("getAllSessions", HttpCommandExecutor.get("/sessions")).put("newSession", HttpCommandExecutor.post("/session")).put("getCapabilities", HttpCommandExecutor.get("/session/:sessionId")).put("quit", HttpCommandExecutor.delete("/session/:sessionId")).put("getCurrentWindowHandle", HttpCommandExecutor.get("/session/:sessionId/window_handle")).put("getWindowHandles", HttpCommandExecutor.get("/session/:sessionId/window_handles")).put("get", HttpCommandExecutor.post("/session/:sessionId/url")).put("getAlert", HttpCommandExecutor.get("/session/:sessionId/alert")).put("dismissAlert", HttpCommandExecutor.post("/session/:sessionId/dismiss_alert")).put("acceptAlert", HttpCommandExecutor.post("/session/:sessionId/accept_alert")).put("getAlertText", HttpCommandExecutor.get("/session/:sessionId/alert_text")).put("setAlertValue", HttpCommandExecutor.post("/session/:sessionId/alert_text")).put("goForward", HttpCommandExecutor.post("/session/:sessionId/forward")).put("goBack", HttpCommandExecutor.post("/session/:sessionId/back")).put("refresh", HttpCommandExecutor.post("/session/:sessionId/refresh")).put("executeScript", HttpCommandExecutor.post("/session/:sessionId/execute")).put("executeAsyncScript", HttpCommandExecutor.post("/session/:sessionId/execute_async")).put("getCurrentUrl", HttpCommandExecutor.get("/session/:sessionId/url")).put("getTitle", HttpCommandExecutor.get("/session/:sessionId/title")).put("getPageSource", HttpCommandExecutor.get("/session/:sessionId/source")).put("screenshot", HttpCommandExecutor.get("/session/:sessionId/screenshot")).put("setBrowserVisible", HttpCommandExecutor.post("/session/:sessionId/visible")).put("isBrowserVisible", HttpCommandExecutor.get("/session/:sessionId/visible")).put("findElement", HttpCommandExecutor.post("/session/:sessionId/element")).put("findElements", HttpCommandExecutor.post("/session/:sessionId/elements")).put("getActiveElement", HttpCommandExecutor.post("/session/:sessionId/element/active")).put("findChildElement", HttpCommandExecutor.post("/session/:sessionId/element/:id/element")).put("findChildElements", HttpCommandExecutor.post("/session/:sessionId/element/:id/elements")).put("clickElement", HttpCommandExecutor.post("/session/:sessionId/element/:id/click")).put("clearElement", HttpCommandExecutor.post("/session/:sessionId/element/:id/clear")).put("submitElement", HttpCommandExecutor.post("/session/:sessionId/element/:id/submit")).put("getElementText", HttpCommandExecutor.get("/session/:sessionId/element/:id/text")).put("sendKeysToElement", HttpCommandExecutor.post("/session/:sessionId/element/:id/value")).put("uploadFile", HttpCommandExecutor.post("/session/:sessionId/file")).put("getElementValue", HttpCommandExecutor.get("/session/:sessionId/element/:id/value")).put("getElementTagName", HttpCommandExecutor.get("/session/:sessionId/element/:id/name")).put("isElementSelected", HttpCommandExecutor.get("/session/:sessionId/element/:id/selected")).put("isElementEnabled", HttpCommandExecutor.get("/session/:sessionId/element/:id/enabled")).put("isElementDisplayed", HttpCommandExecutor.get("/session/:sessionId/element/:id/displayed")).put("hoverOverElement", HttpCommandExecutor.post("/session/:sessionId/element/:id/hover")).put("getElementLocation", HttpCommandExecutor.get("/session/:sessionId/element/:id/location")).put("getElementLocationOnceScrolledIntoView", HttpCommandExecutor.get("/session/:sessionId/element/:id/location_in_view")).put("getElementSize", HttpCommandExecutor.get("/session/:sessionId/element/:id/size")).put("getElementAttribute", HttpCommandExecutor.get("/session/:sessionId/element/:id/attribute/:name")).put("elementEquals", HttpCommandExecutor.get("/session/:sessionId/element/:id/equals/:other")).put("getCookies", HttpCommandExecutor.get("/session/:sessionId/cookie")).put("addCookie", HttpCommandExecutor.post("/session/:sessionId/cookie")).put("deleteAllCookies", HttpCommandExecutor.delete("/session/:sessionId/cookie")).put("deleteCookie", HttpCommandExecutor.delete("/session/:sessionId/cookie/:name")).put("switchToFrame", HttpCommandExecutor.post("/session/:sessionId/frame")).put("switchToWindow", HttpCommandExecutor.post("/session/:sessionId/window")).put("getWindowSize", HttpCommandExecutor.get("/session/:sessionId/window/:windowHandle/size")).put("getWindowPosition", HttpCommandExecutor.get("/session/:sessionId/window/:windowHandle/position")).put("setWindowSize", HttpCommandExecutor.post("/session/:sessionId/window/:windowHandle/size")).put("setWindowPosition", HttpCommandExecutor.post("/session/:sessionId/window/:windowHandle/position")).put("maximizeWindow", HttpCommandExecutor.post("/session/:sessionId/window/:windowHandle/maximize")).put("close", HttpCommandExecutor.delete("/session/:sessionId/window")).put("dragElement", HttpCommandExecutor.post("/session/:sessionId/element/:id/drag")).put("getElementValueOfCssProperty", HttpCommandExecutor.get("/session/:sessionId/element/:id/css/:propertyName")).put("implicitlyWait", HttpCommandExecutor.post("/session/:sessionId/timeouts/implicit_wait")).put("setScriptTimeout", HttpCommandExecutor.post("/session/:sessionId/timeouts/async_script")).put("setTimeout", HttpCommandExecutor.post("/session/:sessionId/timeouts")).put("executeSQL", HttpCommandExecutor.post("/session/:sessionId/execute_sql")).put("getLocation", HttpCommandExecutor.get("/session/:sessionId/location")).put("setLocation", HttpCommandExecutor.post("/session/:sessionId/location")).put("getStatus", HttpCommandExecutor.get("/session/:sessionId/application_cache/status")).put("isBrowserOnline", HttpCommandExecutor.get("/session/:sessionId/browser_connection")).put("setBrowserOnline", HttpCommandExecutor.post("/session/:sessionId/browser_connection")).put("getLocalStorageItem", HttpCommandExecutor.get("/session/:sessionId/local_storage/key/:key")).put("removeLocalStorageItem", HttpCommandExecutor.delete("/session/:sessionId/local_storage/key/:key")).put("getLocalStorageKeys", HttpCommandExecutor.get("/session/:sessionId/local_storage")).put("setLocalStorageItem", HttpCommandExecutor.post("/session/:sessionId/local_storage")).put("clearLocalStorage", HttpCommandExecutor.delete("/session/:sessionId/local_storage")).put("getLocalStorageSize", HttpCommandExecutor.get("/session/:sessionId/local_storage/size")).put("getSessionStorageItem", HttpCommandExecutor.get("/session/:sessionId/session_storage/key/:key")).put("removeSessionStorageItem", HttpCommandExecutor.delete("/session/:sessionId/session_storage/key/:key")).put("getSessionStorageKey", HttpCommandExecutor.get("/session/:sessionId/session_storage")).put("setSessionStorageItem", HttpCommandExecutor.post("/session/:sessionId/session_storage")).put("clearSessionStorage", HttpCommandExecutor.delete("/session/:sessionId/session_storage")).put("getSessionStorageSize", HttpCommandExecutor.get("/session/:sessionId/session_storage/size")).put("getScreenOrientation", HttpCommandExecutor.get("/session/:sessionId/orientation")).put("setScreenOrientation", HttpCommandExecutor.post("/session/:sessionId/orientation")).put("mouseClick", HttpCommandExecutor.post("/session/:sessionId/click")).put("mouseDoubleClick", HttpCommandExecutor.post("/session/:sessionId/doubleclick")).put("mouseButtonDown", HttpCommandExecutor.post("/session/:sessionId/buttondown")).put("mouseButtonUp", HttpCommandExecutor.post("/session/:sessionId/buttonup")).put("mouseMoveTo", HttpCommandExecutor.post("/session/:sessionId/moveto")).put("sendKeysToActiveElement", HttpCommandExecutor.post("/session/:sessionId/keys")).put("imeGetAvailableEngines", HttpCommandExecutor.get("/session/:sessionId/ime/available_engines")).put("imeGetActiveEngine", HttpCommandExecutor.get("/session/:sessionId/ime/active_engine")).put("imeIsActivated", HttpCommandExecutor.get("/session/:sessionId/ime/activated")).put("imeDeactivate", HttpCommandExecutor.post("/session/:sessionId/ime/deactivate")).put("imeActivateEngine", HttpCommandExecutor.post("/session/:sessionId/ime/activate")).put("touchSingleTap", HttpCommandExecutor.post("/session/:sessionId/touch/click")).put("touchDown", HttpCommandExecutor.post("/session/:sessionId/touch/down")).put("touchUp", HttpCommandExecutor.post("/session/:sessionId/touch/up")).put("touchMove", HttpCommandExecutor.post("/session/:sessionId/touch/move")).put("touchScroll", HttpCommandExecutor.post("/session/:sessionId/touch/scroll")).put("touchDoubleTap", HttpCommandExecutor.post("/session/:sessionId/touch/doubleclick")).put("touchLongPress", HttpCommandExecutor.post("/session/:sessionId/touch/longclick")).put("touchFlick", HttpCommandExecutor.post("/session/:sessionId/touch/flick")).put("getLog", HttpCommandExecutor.post("/session/:sessionId/log")).put("getAvailableLogTypes", HttpCommandExecutor.get("/session/:sessionId/log/types")).put("status", HttpCommandExecutor.get("/status"));
            this.nameToUrl = builder.build();
            return;
        }
    }

    @Override
    public void setLocalLogs(LocalLogs logs) {
        this.logs = logs;
    }

    private void log(String logType, LogEntry entry) {
        this.logs.addEntry(logType, entry);
    }

    public URL getAddressOfRemoteServer() {
        return this.remoteServer;
    }

    @Override
    public Response execute(Command command) throws IOException {
        BasicHttpContext context = new BasicHttpContext();
        if (command.getSessionId() == null) {
            if ("quit".equals(command.getName())) {
                return new Response();
            }
            if (!"getAllSessions".equals(command.getName()) && !"newSession".equals(command.getName())) {
                throw new SessionNotFoundException("Session ID is null");
            }
        }
        CommandInfo info = this.nameToUrl.get(command.getName());
        try {
            HttpUriRequest httpMethod = info.getMethod(this.remoteServer, command);
            this.setAcceptHeader(httpMethod);
            if (httpMethod instanceof HttpPost) {
                String payload = new BeanToJsonConverter().convert(command.getParameters());
                ((HttpPost)httpMethod).setEntity(new StringEntity(payload, "utf-8"));
                httpMethod.addHeader("Content-Type", "application/json; charset=utf-8");
            }
            if (httpMethod instanceof HttpGet) {
                httpMethod.addHeader("Cache-Control", "no-cache");
            }
            this.log("profiler", new HttpProfilerLogEntry(command.getName(), true));
            HttpResponse response = this.fallBackExecute(context, httpMethod);
            this.log("profiler", new HttpProfilerLogEntry(command.getName(), false));
            response = this.followRedirects(this.client, context, response, 0);
            EntityWithEncoding entityWithEncoding = new EntityWithEncoding(response.getEntity());
            return this.createResponse(response, context, entityWithEncoding);
        }
        catch (UnsupportedCommandException e) {
            if (e.getMessage() == null || "".equals(e.getMessage())) {
                throw new UnsupportedOperationException("No information from server. Command name was: " + command.getName(), e.getCause());
            }
            throw e;
        }
    }

    private HttpResponse fallBackExecute(HttpContext context, HttpUriRequest httpMethod) throws IOException {
        try {
            return this.client.execute(this.targetHost, (HttpRequest)httpMethod, context);
        }
        catch (BindException e) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                throw Throwables.propagate(ie);
            }
        }
        catch (NoHttpResponseException e) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                throw Throwables.propagate(ie);
            }
        }
        return this.client.execute(this.targetHost, (HttpRequest)httpMethod, context);
    }

    private void setAcceptHeader(HttpUriRequest httpMethod) {
        httpMethod.addHeader("Accept", "application/json, image/png");
    }

    private HttpResponse followRedirects(HttpClient client, HttpContext context, HttpResponse response, int redirectCount) {
        if (!this.isRedirect(response)) {
            return response;
        }
        try {
            HttpEntity httpEntity = response.getEntity();
            if (httpEntity != null) {
                EntityUtils.consume(httpEntity);
            }
        }
        catch (IOException e) {
            throw new WebDriverException(e);
        }
        if (redirectCount > 10) {
            throw new WebDriverException("Maximum number of redirects exceeded. Aborting");
        }
        String location = response.getFirstHeader("location").getValue();
        try {
            URI uri = this.buildUri(context, location);
            HttpGet get = new HttpGet(uri);
            this.setAcceptHeader(get);
            HttpResponse newResponse = client.execute(this.targetHost, (HttpRequest)get, context);
            return this.followRedirects(client, context, newResponse, redirectCount + 1);
        }
        catch (URISyntaxException e) {
            throw new WebDriverException(e);
        }
        catch (ClientProtocolException e) {
            throw new WebDriverException(e);
        }
        catch (IOException e) {
            throw new WebDriverException(e);
        }
    }

    private URI buildUri(HttpContext context, String location) throws URISyntaxException {
        URI uri = new URI(location);
        if (!uri.isAbsolute()) {
            HttpHost host = (HttpHost)context.getAttribute("http.target_host");
            uri = new URI(host.toURI() + location);
        }
        return uri;
    }

    private boolean isRedirect(HttpResponse response) {
        int code = response.getStatusLine().getStatusCode();
        return (code == 301 || code == 302 || code == 303 || code == 307) && response.containsHeader("location");
    }

    private Response createResponse(HttpResponse httpResponse, HttpContext context, EntityWithEncoding entityWithEncoding) throws IOException {
        Response response;
        Header header = httpResponse.getFirstHeader("Content-Type");
        if (header != null && header.getValue().startsWith("application/json")) {
            String responseAsText = entityWithEncoding.getContentString();
            try {
                response = new JsonToBeanConverter().convert(Response.class, responseAsText);
            }
            catch (ClassCastException e) {
                if (responseAsText != null && "".equals(responseAsText)) {
                    return null;
                }
                throw new WebDriverException("Cannot convert text to response: " + responseAsText, e);
            }
        } else {
            int statusCode;
            response = new Response();
            if (header != null && header.getValue().startsWith("image/png")) {
                response.setValue(entityWithEncoding.getContent());
            } else if (entityWithEncoding.hasEntityContent()) {
                response.setValue(entityWithEncoding.getContentString());
            }
            HttpHost finalHost = (HttpHost)context.getAttribute("http.target_host");
            String uri = finalHost.toURI();
            String sessionId = HttpSessionId.getSessionId(uri);
            if (sessionId != null) {
                response.setSessionId(sessionId);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) <= 199 || statusCode >= 300) {
                if (statusCode > 399 && statusCode < 500) {
                    response.setStatus(9);
                } else if (statusCode > 499 && statusCode < 600) {
                    if (response.getStatus() == 0) {
                        response.setStatus(13);
                    }
                } else {
                    response.setStatus(13);
                }
            }
            if (response.getValue() instanceof String) {
                response.setValue(((String)response.getValue()).replace("\r\n", "\n"));
            }
        }
        response.setState(this.errorCodes.toState(response.getStatus()));
        return response;
    }

    private static CommandInfo get(String url) {
        return new CommandInfo(url, HttpVerb.GET);
    }

    private static CommandInfo post(String url) {
        return new CommandInfo(url, HttpVerb.POST);
    }

    private static CommandInfo delete(String url) {
        return new CommandInfo(url, HttpVerb.DELETE);
    }

    class EntityWithEncoding {
        private final String charSet;
        private final byte[] content;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        EntityWithEncoding(HttpEntity entity) throws IOException {
            try {
                if (entity != null) {
                    this.content = EntityUtils.toByteArray(entity);
                    Charset entityCharset = ContentType.getOrDefault(entity).getCharset();
                    this.charSet = entityCharset != null ? entityCharset.name() : null;
                } else {
                    this.content = new byte[0];
                    this.charSet = null;
                }
            }
            finally {
                EntityUtils.consume(entity);
            }
        }

        public String getContentString() throws UnsupportedEncodingException {
            return new String(this.content, this.charSet != null ? this.charSet : "utf-8");
        }

        public byte[] getContent() {
            return this.content;
        }

        public boolean hasEntityContent() {
            return this.content != null;
        }
    }
}

