/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server.model;

import com.beust.jcommander.internal.Lists;
import io.selendroid.SelendroidCapabilities;
import io.selendroid.SelendroidConfiguration;
import io.selendroid.android.AndroidApp;
import io.selendroid.android.AndroidDevice;
import io.selendroid.android.AndroidEmulator;
import io.selendroid.android.AndroidSdk;
import io.selendroid.android.DeviceManager;
import io.selendroid.android.impl.DefaultAndroidEmulator;
import io.selendroid.android.impl.DefaultDeviceManager;
import io.selendroid.android.impl.DefaultHardwareDevice;
import io.selendroid.builder.AndroidDriverAPKBuilder;
import io.selendroid.builder.SelendroidServerBuilder;
import io.selendroid.exceptions.AndroidDeviceException;
import io.selendroid.exceptions.AndroidSdkException;
import io.selendroid.exceptions.DeviceStoreException;
import io.selendroid.exceptions.SelendroidException;
import io.selendroid.exceptions.SessionNotCreatedException;
import io.selendroid.exceptions.ShellCommandException;
import io.selendroid.server.ServerDetails;
import io.selendroid.server.model.ActiveSession;
import io.selendroid.server.model.DefaultHardwareDeviceListener;
import io.selendroid.server.model.DeviceStore;
import io.selendroid.server.util.HttpClientUtil;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class SelendroidStandaloneDriver
implements ServerDetails {
    public static final String WD_RESP_KEY_VALUE = "value";
    public static final String WD_RESP_KEY_STATUS = "status";
    public static final String WD_RESP_KEY_SESSION_ID = "sessionId";
    private static int selendroidServerPort = 38080;
    private static final Logger log = Logger.getLogger(SelendroidStandaloneDriver.class.getName());
    private Map<String, AndroidApp> appsStore = new HashMap<String, AndroidApp>();
    private Map<String, AndroidApp> selendroidServers = new HashMap<String, AndroidApp>();
    private Map<String, ActiveSession> sessions = new HashMap<String, ActiveSession>();
    private DeviceStore deviceStore = null;
    private SelendroidServerBuilder selendroidApkBuilder = null;
    private AndroidDriverAPKBuilder androidDriverAPKBuilder = null;
    private SelendroidConfiguration serverConfiguration = null;
    private DeviceManager deviceManager;

    public SelendroidStandaloneDriver(SelendroidConfiguration serverConfiguration) throws AndroidSdkException, AndroidDeviceException {
        this.serverConfiguration = serverConfiguration;
        this.selendroidApkBuilder = new SelendroidServerBuilder(serverConfiguration);
        this.androidDriverAPKBuilder = new AndroidDriverAPKBuilder();
        selendroidServerPort = serverConfiguration.getSelendroidServerPort();
        this.initApplicationsUnderTest(serverConfiguration);
        this.initAndroidDevices();
        this.deviceStore.setClearData(!serverConfiguration.isNoClearData());
    }

    SelendroidStandaloneDriver(SelendroidServerBuilder builder, DeviceManager deviceManager, AndroidDriverAPKBuilder androidDriverAPKBuilder) {
        this.selendroidApkBuilder = builder;
        this.deviceManager = deviceManager;
        this.androidDriverAPKBuilder = androidDriverAPKBuilder;
    }

    void initApplicationsUnderTest(SelendroidConfiguration serverConfiguration) throws AndroidSdkException {
        if (serverConfiguration == null) {
            throw new SelendroidException("Configuration error - serverConfiguration can't be null.");
        }
        this.serverConfiguration = serverConfiguration;
        for (String appPath : serverConfiguration.getSupportedApps()) {
            File file = new File(appPath);
            if (file.exists()) {
                AndroidApp app = null;
                try {
                    app = this.selendroidApkBuilder.resignApp(file);
                }
                catch (ShellCommandException e1) {
                    throw new SessionNotCreatedException("An error occurred while resigning the app '" + file.getName() + "'. ", e1);
                }
                String appId = null;
                try {
                    appId = app.getAppId();
                }
                catch (SelendroidException e) {
                    log.info("Ignoring app because an error occurred reading the app details: " + file.getAbsolutePath());
                    log.info(e.getMessage());
                }
                if (appId == null || this.appsStore.containsKey(appId)) continue;
                this.appsStore.put(appId, app);
                log.info("App " + appId + " has been added to selendroid standalone server.");
                continue;
            }
            log.severe("Ignoring app because it was not found: " + file.getAbsolutePath());
        }
        if (!serverConfiguration.isNoWebViewApp()) {
            try {
                AndroidApp app = this.selendroidApkBuilder.resignApp(this.androidDriverAPKBuilder.extractAndroidDriverAPK());
                this.appsStore.put("android", app);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (this.appsStore.isEmpty()) {
            throw new SelendroidException("Fatal error initializing SelendroidDriver: configured app(s) have not been found.");
        }
    }

    void initAndroidDevices() throws AndroidDeviceException {
        this.deviceManager = new DefaultDeviceManager(AndroidSdk.adb().getAbsolutePath(), this.serverConfiguration.shouldKeepAdbAlive());
        this.deviceStore = new DeviceStore(this.serverConfiguration.isVerbose(), this.serverConfiguration.getEmulatorPort(), this.deviceManager);
        this.deviceStore.initAndroidDevices(new DefaultHardwareDeviceListener(this.deviceStore, this), this.serverConfiguration.shouldKeepAdbAlive());
    }

    @Override
    public String getServerVersion() {
        SelendroidStandaloneDriver selendroidStandaloneDriver = this;
        return selendroidStandaloneDriver.selendroidApkBuilder.getJarVersionNumber();
    }

    @Override
    public String getCpuArch() {
        String arch = System.getProperty("os.arch");
        return arch;
    }

    @Override
    public String getOsVersion() {
        String os = System.getProperty("os.version");
        return os;
    }

    @Override
    public String getOsName() {
        String os = System.getProperty("os.name");
        return os;
    }

    protected SelendroidConfiguration getSelendroidConfiguration() {
        return this.serverConfiguration;
    }

    public String createNewTestSession(JSONObject caps, Integer retries) throws AndroidSdkException, JSONException {
        RemoteWebDriver driver;
        boolean appInstalledOneDevice;
        SelendroidCapabilities desiredCapabilities = null;
        try {
            desiredCapabilities = new SelendroidCapabilities(caps);
        }
        catch (JSONException e) {
            throw new SelendroidException("Desired capabilities cannot be parsed.");
        }
        AndroidApp app = this.appsStore.get(desiredCapabilities.getAut());
        if (app == null) {
            throw new SessionNotCreatedException("The requested application under test is not configured in selendroid server.");
        }
        AndroidDevice device = null;
        try {
            device = this.getAndroidDevice(desiredCapabilities);
        }
        catch (AndroidDeviceException e) {
            SessionNotCreatedException error = new SessionNotCreatedException("Error occured while finding android device: " + e.getMessage());
            e.printStackTrace();
            log.severe(error.getMessage());
            throw error;
        }
        if (device instanceof AndroidEmulator) {
            AndroidEmulator emulator = (AndroidEmulator)((Object)device);
            try {
                if (emulator.isEmulatorStarted()) {
                    emulator.unlockEmulatorScreen();
                } else {
                    HashMap<String, Object> config = new HashMap<String, Object>();
                    if (this.serverConfiguration.getEmulatorOptions() != null) {
                        config.put("OPTIONS", this.serverConfiguration.getEmulatorOptions());
                    }
                    config.put("TIMEOUT", this.serverConfiguration.getTimeoutEmulatorStart());
                    if (desiredCapabilities.asMap().containsKey("display")) {
                        Object d = desiredCapabilities.getCapability("display");
                        config.put("DISPLAY", String.valueOf(d));
                    }
                    Locale locale = this.parseLocale(desiredCapabilities);
                    emulator.start(locale, this.deviceStore.nextEmulatorPort(), config);
                }
            }
            catch (AndroidDeviceException e) {
                this.deviceStore.release(device, app);
                if (retries > 0) {
                    return this.createNewTestSession(caps, retries - 1);
                }
                throw new SessionNotCreatedException("Error occured while interacting with the emulator: " + emulator + ": " + e.getMessage());
            }
            emulator.setIDevice(this.deviceManager.getVirtualDevice(emulator.getAvdName()));
        }
        if (!(appInstalledOneDevice = device.isInstalled(app))) {
            device.install(app);
        } else {
            log.info("the app under test is already installed.");
        }
        int port = this.getNextSelendroidServerPort();
        Boolean selendroidInstalledSuccessfully = device.isInstalled("io.selendroid." + app.getBasePackage());
        if (!selendroidInstalledSuccessfully.booleanValue()) {
            AndroidApp selendroidServer = this.createSelendroidServerApk(app);
            selendroidInstalledSuccessfully = device.install(selendroidServer);
            if (!selendroidInstalledSuccessfully.booleanValue() && !device.install(selendroidServer).booleanValue()) {
                this.deviceStore.release(device, app);
                if (retries > 0) {
                    return this.createNewTestSession(caps, retries - 1);
                }
            }
        } else {
            log.info("selendroid-server will not be created and installed because it already exists for the app under test.");
        }
        List<String> adbCommands = desiredCapabilities.getPreSessionAdbCommands();
        if (adbCommands != null && !adbCommands.isEmpty()) {
            for (String adbCommandParameter : adbCommands) {
                device.runAdbCommand(adbCommandParameter);
            }
        }
        try {
            device.startSelendroid(app, port);
        }
        catch (AndroidSdkException e) {
            log.info("error while starting selendroid: " + e.getMessage());
            this.deviceStore.release(device, app);
            if (retries > 0) {
                return this.createNewTestSession(caps, retries - 1);
            }
            throw new SessionNotCreatedException("Error occurred while starting instrumentation: " + e.getMessage());
        }
        long start = System.currentTimeMillis();
        long startTimeOut = 20000L;
        long timemoutEnd = start + startTimeOut;
        while (!device.isSelendroidRunning()) {
            if (timemoutEnd >= System.currentTimeMillis()) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {}
                continue;
            }
            throw new SelendroidException("Selendroid server on the device didn't came up after " + startTimeOut / 1000L + "sec:");
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        try {
            driver = new RemoteWebDriver(new URL("http://localhost:" + port + "/wd/hub"), (Capabilities)desiredCapabilities);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.deviceStore.release(device, app);
            throw new SessionNotCreatedException("Error occurred while creating session on Android device", e);
        }
        String sessionId = driver.getSessionId().toString();
        SelendroidCapabilities requiredCapabilities = new SelendroidCapabilities(driver.getCapabilities().asMap());
        ActiveSession session = new ActiveSession(sessionId, requiredCapabilities, app, device, port, this);
        this.sessions.put(sessionId, session);
        if ("android".equals(desiredCapabilities.getAut())) {
            WebDriverWait wait = new WebDriverWait(driver, 60L);
            wait.until(ExpectedConditions.visibilityOfElementLocated(By.className("android.webkit.WebView")));
            driver.switchTo().window("WEBVIEW");
            wait.until(ExpectedConditions.visibilityOfElementLocated(By.id("AndroidDriver")));
        }
        return sessionId;
    }

    private AndroidApp createSelendroidServerApk(AndroidApp aut) throws AndroidSdkException {
        if (!this.selendroidServers.containsKey(aut.getAppId())) {
            try {
                AndroidApp selendroidServer = this.selendroidApkBuilder.createSelendroidServer(aut);
                this.selendroidServers.put(aut.getAppId(), selendroidServer);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SessionNotCreatedException("An error occurred while building the selendroid-server.apk for aut '" + aut + "': " + e.getMessage());
            }
        }
        return this.selendroidServers.get(aut.getAppId());
    }

    private Locale parseLocale(SelendroidCapabilities capa) {
        if (capa.getLocale() == null) {
            return null;
        }
        String[] localeStr = capa.getLocale().split("_");
        Locale locale = new Locale(localeStr[0], localeStr[1]);
        return locale;
    }

    AndroidDevice getAndroidDevice(SelendroidCapabilities caps) throws AndroidDeviceException {
        AndroidDevice device = null;
        try {
            device = this.deviceStore.findAndroidDevice(caps);
        }
        catch (DeviceStoreException e) {
            e.printStackTrace();
            log.fine(caps.getRawCapabilities().toString());
            throw new AndroidDeviceException("Error occurred while looking for devices/emulators.", e);
        }
        return device;
    }

    Map<String, AndroidApp> getConfiguredApps() {
        return Collections.unmodifiableMap(this.appsStore);
    }

    void setDeviceStore(DeviceStore store) {
        this.deviceStore = store;
    }

    private synchronized int getNextSelendroidServerPort() {
        return selendroidServerPort++;
    }

    public List<ActiveSession> getActiveSessions() {
        return Lists.newArrayList(this.sessions.values());
    }

    public boolean isValidSession(String sessionId) {
        if (sessionId != null && !sessionId.isEmpty()) {
            return this.sessions.containsKey(sessionId);
        }
        return false;
    }

    public void stopSession(String sessionId) throws AndroidDeviceException {
        if (this.isValidSession(sessionId)) {
            ActiveSession session = this.sessions.get(sessionId);
            session.stopSessionTimer();
            try {
                HttpClientUtil.executeRequest("http://localhost:" + session.getSelendroidServerPort() + "/wd/hub/session/" + sessionId, HttpMethod.DELETE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.deviceStore.release(session.getDevice(), session.getAut());
            this.sessions.remove(sessionId);
            Object var2_2 = null;
        }
    }

    public void quitSelendroid() {
        List<String> sessionsToQuit = Lists.newArrayList(this.sessions.keySet());
        if (sessionsToQuit != null && !sessionsToQuit.isEmpty()) {
            for (String sessionId : sessionsToQuit) {
                try {
                    this.stopSession(sessionId);
                }
                catch (AndroidDeviceException e) {
                    log.severe("Error occured while stopping session: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        this.deviceManager.shutdown();
    }

    public SelendroidCapabilities getSessionCapabilities(String sessionId) {
        if (this.sessions.containsKey(sessionId)) {
            return this.sessions.get(sessionId).getDesiredCapabilities();
        }
        return null;
    }

    public ActiveSession getActiveSession(String sessionId) {
        if (sessionId != null && this.sessions.containsKey(sessionId)) {
            return this.sessions.get(sessionId);
        }
        return null;
    }

    @Override
    public synchronized JSONArray getSupportedApps() {
        JSONArray list = new JSONArray();
        for (AndroidApp app : this.appsStore.values()) {
            JSONObject appInfo = new JSONObject();
            try {
                appInfo.put("appId", app.getAppId());
                appInfo.put("basePackage", app.getBasePackage());
                appInfo.put("mainActivity", app.getMainActivity());
                list.put(appInfo);
            }
            catch (Exception e) {}
        }
        return list;
    }

    @Override
    public synchronized JSONArray getSupportedDevices() {
        JSONArray list = new JSONArray();
        for (AndroidDevice device : this.deviceStore.getDevices()) {
            JSONObject deviceInfo = new JSONObject();
            try {
                if (device instanceof DefaultAndroidEmulator) {
                    deviceInfo.put("emulator", true);
                    deviceInfo.put("avdName", ((DefaultAndroidEmulator)device).getAvdName());
                } else {
                    deviceInfo.put("emulator", false);
                    deviceInfo.put("model", ((DefaultHardwareDevice)device).getModel());
                }
                deviceInfo.put("androidTarget", (Object)device.getTargetPlatform());
                deviceInfo.put("screenSize", device.getScreenSize());
                list.put(deviceInfo);
            }
            catch (Exception e) {
                log.info("Error occured when building suported device info: " + e.getMessage());
            }
        }
        return list;
    }

    protected ActiveSession findActiveSession(AndroidDevice device) {
        for (ActiveSession session : this.sessions.values()) {
            if (!session.getDevice().equals(device)) continue;
            return session;
        }
        return null;
    }

    public byte[] takeScreenshot(String sessionId) throws AndroidDeviceException {
        if (sessionId == null || !this.sessions.containsKey(sessionId)) {
            throw new SelendroidException("The gicen session id '" + sessionId + "' was not found.");
        }
        return this.sessions.get(sessionId).getDevice().takeScreenshot();
    }
}

