/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server.model;

import io.selendroid.SelendroidCapabilities;
import io.selendroid.android.AndroidApp;
import io.selendroid.android.AndroidDevice;
import io.selendroid.android.AndroidEmulator;
import io.selendroid.android.AndroidEmulatorPowerStateListener;
import io.selendroid.android.DeviceManager;
import io.selendroid.android.HardwareDeviceListener;
import io.selendroid.android.impl.DefaultAndroidEmulator;
import io.selendroid.android.impl.DefaultHardwareDevice;
import io.selendroid.device.DeviceTargetPlatform;
import io.selendroid.exceptions.AndroidDeviceException;
import io.selendroid.exceptions.AndroidSdkException;
import io.selendroid.exceptions.DeviceStoreException;
import io.selendroid.exceptions.SelendroidException;
import io.selendroid.server.model.EmulatorPortFinder;
import io.selendroid.server.model.impl.DefaultPortFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeviceStore {
    private static final Logger log = Logger.getLogger(DeviceStore.class.getName());
    private List<AndroidDevice> devicesInUse = new ArrayList<AndroidDevice>();
    private Map<DeviceTargetPlatform, List<AndroidDevice>> androidDevices = new HashMap<DeviceTargetPlatform, List<AndroidDevice>>();
    private EmulatorPortFinder androidEmulatorPortFinder = null;
    private boolean clearData = true;
    private AndroidEmulatorPowerStateListener emulatorPowerStateListener = null;
    private DeviceManager deviceManager = null;

    public DeviceStore(Boolean debug, Integer emulatorPort, DeviceManager deviceManager) {
        if (debug.booleanValue()) {
            log.setLevel(Level.FINE);
        }
        this.deviceManager = deviceManager;
        this.androidEmulatorPortFinder = new DefaultPortFinder(emulatorPort, emulatorPort + 30);
    }

    public DeviceStore(EmulatorPortFinder androidEmulatorPortFinder, Boolean debug, DeviceManager deviceManager) {
        if (debug.booleanValue()) {
            log.setLevel(Level.FINE);
        }
        this.deviceManager = deviceManager;
        this.androidEmulatorPortFinder = androidEmulatorPortFinder;
    }

    public Integer nextEmulatorPort() {
        return this.androidEmulatorPortFinder.next();
    }

    public void release(AndroidDevice device, AndroidApp aut) {
        if (this.devicesInUse.contains(device)) {
            try {
                device.kill(aut);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.clearData) {
                try {
                    device.clearUserData(aut);
                }
                catch (AndroidSdkException e) {
                    e.printStackTrace();
                }
            }
            if (device instanceof AndroidEmulator) {
                AndroidEmulator emulator = (AndroidEmulator)((Object)device);
                try {
                    emulator.stop();
                }
                catch (AndroidDeviceException e) {
                    log.severe("Failed to stop emulator: " + e.getMessage());
                }
                this.androidEmulatorPortFinder.release(emulator.getPort());
            }
            this.devicesInUse.remove(device);
        }
    }

    void initAndroidDevices(HardwareDeviceListener hardwareDeviceListener, boolean shouldKeepAdbAlive) throws AndroidDeviceException {
        this.emulatorPowerStateListener = new DefaultEmulatorPowerStateListener();
        this.deviceManager.initialize(hardwareDeviceListener, this.emulatorPowerStateListener);
        List<AndroidEmulator> emulators = DefaultAndroidEmulator.listAvailableAvds();
        this.addEmulators(emulators);
        if (this.getDevices().isEmpty()) {
            SelendroidException e = new SelendroidException("No android virtual devices were found. Please start the android tool and create emulators and restart the selendroid-standalone or plugin an Android hardware device via USB.");
            log.warning("Warning: " + e);
        }
    }

    public synchronized void addDevice(AndroidDevice androidDevice) throws AndroidDeviceException {
        if (androidDevice == null) {
            log.info("No Android devices were found.");
            return;
        }
        if (androidDevice instanceof AndroidEmulator) {
            throw new AndroidDeviceException("For adding emulator instances please use #addEmulator method.");
        }
        if (androidDevice.isDeviceReady()) {
            log.info("Adding: " + androidDevice);
            this.addDeviceToStore(androidDevice);
        }
    }

    public void addEmulators(List<AndroidEmulator> emulators) throws AndroidDeviceException {
        if (emulators == null || emulators.isEmpty()) {
            log.info("No emulators has been found.");
            return;
        }
        for (AndroidEmulator emulator : emulators) {
            log.info("Adding: " + emulator);
            this.addDeviceToStore((AndroidDevice)((Object)emulator));
        }
    }

    protected synchronized void addDeviceToStore(AndroidDevice device) throws AndroidDeviceException {
        if (this.androidDevices.containsKey((Object)device.getTargetPlatform())) {
            if (this.androidDevices.get((Object)device.getTargetPlatform()) == null) {
                this.androidDevices.put(device.getTargetPlatform(), new ArrayList());
            }
            this.androidDevices.get((Object)device.getTargetPlatform()).add(device);
        } else {
            ArrayList<AndroidDevice> devices = new ArrayList<AndroidDevice>();
            devices.add(device);
            this.androidDevices.put(device.getTargetPlatform(), devices);
        }
    }

    public synchronized AndroidDevice findAndroidDevice(SelendroidCapabilities caps) throws DeviceStoreException {
        if (caps == null) {
            throw new IllegalArgumentException("Error: capabilities are null");
        }
        if (this.androidDevices.isEmpty()) {
            throw new DeviceStoreException("Fatal Error: Device Store does not contain any Android Device.");
        }
        String platformVersion = caps.getPlatformVersion();
        if (platformVersion == null || platformVersion.isEmpty()) {
            platformVersion = caps.getAndroidTarget();
        }
        List<Object> devices = null;
        if (platformVersion == null || platformVersion.isEmpty()) {
            devices = new ArrayList();
            for (List<AndroidDevice> list : this.androidDevices.values()) {
                devices.addAll(list);
            }
        } else {
            DeviceTargetPlatform platform = DeviceTargetPlatform.fromPlatformVersion(platformVersion);
            devices = this.androidDevices.get((Object)platform);
        }
        if (devices == null) {
            devices = new ArrayList();
        }
        ArrayList<AndroidDevice> potentialMatches = new ArrayList<AndroidDevice>();
        for (AndroidDevice androidDevice : devices) {
            log.fine("Evaluating if this device is a match for us: " + androidDevice.toString());
            if (androidDevice.screenSizeMatches(caps.getScreenSize())) {
                if (this.devicesInUse.contains(androidDevice)) {
                    log.fine("Device is in use.");
                    continue;
                }
                if (caps.getEmulator() != null && (!caps.getEmulator().booleanValue() || !(androidDevice instanceof DefaultAndroidEmulator)) && (caps.getEmulator().booleanValue() || !(androidDevice instanceof DefaultHardwareDevice))) continue;
                if (androidDevice instanceof AndroidEmulator) {
                    potentialMatches.add(androidDevice);
                    continue;
                }
                String serial = caps.getSerial();
                if (androidDevice instanceof AndroidDevice && (serial == null || ((DefaultHardwareDevice)androidDevice).getSerial().equals(serial))) {
                    this.devicesInUse.add(androidDevice);
                    return androidDevice;
                }
                if (androidDevice instanceof AndroidDevice && !((DefaultHardwareDevice)androidDevice).getSerial().equals(serial)) continue;
                log.fine("device found.");
                this.devicesInUse.add(androidDevice);
                return androidDevice;
            }
            log.info("emulator switched off: " + this.isEmulatorSwitchedOff(androidDevice));
        }
        if (potentialMatches.size() > 0) {
            this.devicesInUse.add((AndroidDevice)potentialMatches.get(0));
            return (AndroidDevice)potentialMatches.get(0);
        }
        throw new DeviceStoreException("No devices are found. This can happen if the devices are in use or no device screen matches the required capabilities.");
    }

    private boolean isEmulatorSwitchedOff(AndroidDevice device) throws DeviceStoreException {
        if (device instanceof AndroidEmulator) {
            try {
                return !((AndroidEmulator)((Object)device)).isEmulatorStarted();
            }
            catch (AndroidDeviceException e) {
                throw new DeviceStoreException(e);
            }
        }
        return true;
    }

    public List<AndroidDevice> getDevices() {
        ArrayList<AndroidDevice> devices = new ArrayList<AndroidDevice>();
        for (Map.Entry<DeviceTargetPlatform, List<AndroidDevice>> entry : this.androidDevices.entrySet()) {
            devices.addAll((Collection<AndroidDevice>)entry.getValue());
        }
        return devices;
    }

    List<AndroidDevice> getDevicesInUse() {
        return this.devicesInUse;
    }

    Map<DeviceTargetPlatform, List<AndroidDevice>> getDevicesList() {
        return this.androidDevices;
    }

    public void removeAndroidDevice(AndroidDevice device) throws DeviceStoreException {
        if (device == null) {
            return;
        }
        boolean hardwareDevice = device instanceof DefaultHardwareDevice;
        if (!hardwareDevice) {
            throw new DeviceStoreException("Only devices of type 'DefaultHardwareDevice' can be removed.");
        }
        this.release(device, null);
        DeviceTargetPlatform apiLevel = device.getTargetPlatform();
        if (this.androidDevices.containsKey((Object)apiLevel)) {
            log.info("Removing: " + device);
            this.androidDevices.get((Object)apiLevel).remove(device);
            if (this.androidDevices.get((Object)apiLevel).isEmpty()) {
                this.androidDevices.remove((Object)apiLevel);
            }
        } else {
            log.warning("The target platform version of the device is not found in device store.");
            log.warning("The device was propably already removed.");
        }
    }

    public void setClearData(boolean clearData) {
        this.clearData = clearData;
    }

    class DefaultEmulatorPowerStateListener
    implements AndroidEmulatorPowerStateListener {
        DefaultEmulatorPowerStateListener() {
        }

        @Override
        public void onDeviceStarted(String avdName, String serial) {
            AndroidEmulator emulator = this.findEmulator(avdName);
            if (emulator != null) {
                Integer port = Integer.parseInt(serial.replace("emulator-", ""));
                emulator.setSerial(port);
                emulator.setWasStartedBySelendroid(false);
            }
        }

        AndroidEmulator findEmulator(String avdName) {
            for (AndroidDevice device : DeviceStore.this.getDevices()) {
                AndroidEmulator emulator;
                if (!(device instanceof AndroidEmulator) || !avdName.equals((emulator = (AndroidEmulator)((Object)device)).getAvdName())) continue;
                return emulator;
            }
            return null;
        }

        @Override
        public void onDeviceStopped(String avdName) {
        }
    }
}

