/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server.model;

import io.selendroid.SelendroidCapabilities;
import io.selendroid.android.AndroidApp;
import io.selendroid.android.AndroidDevice;
import io.selendroid.server.model.SelendroidStandaloneDriver;
import io.selendroid.server.model.SessionTimeoutTask;
import java.util.Timer;
import java.util.TimerTask;

public class ActiveSession {
    private final String sessionKey;
    private AndroidApp aut;
    private AndroidDevice device;
    private SelendroidCapabilities desiredCapabilities;
    private final int selendroidServerPort;
    private boolean invalid = false;
    private final Timer stopSessionTimer = new Timer(true);

    ActiveSession(String sessionKey, SelendroidCapabilities desiredCapabilities, AndroidApp aut, AndroidDevice device, int selendroidPort, SelendroidStandaloneDriver driver) {
        this.selendroidServerPort = selendroidPort;
        this.sessionKey = sessionKey;
        this.aut = aut;
        this.device = device;
        this.desiredCapabilities = desiredCapabilities;
        this.stopSessionTimer.schedule((TimerTask)new SessionTimeoutTask(driver, sessionKey), driver.getSelendroidConfiguration().getSessionTimeoutMillis());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActiveSession other = (ActiveSession)obj;
        return !(this.sessionKey == null ? other.sessionKey != null : !this.sessionKey.equals(other.sessionKey));
    }

    public AndroidApp getAut() {
        return this.aut;
    }

    public int getSelendroidServerPort() {
        return this.selendroidServerPort;
    }

    public SelendroidCapabilities getDesiredCapabilities() {
        return this.desiredCapabilities;
    }

    public AndroidDevice getDevice() {
        return this.device;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sessionKey == null ? 0 : this.sessionKey.hashCode());
        return result;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void invalidate() {
        this.invalid = true;
    }

    public void stopSessionTimer() {
        this.stopSessionTimer.cancel();
    }

    public String toString() {
        return "ActiveSession [sessionKey=" + this.sessionKey + ", aut=" + this.aut + ", device=" + this.device + "]";
    }
}

