/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server.handler;

import io.selendroid.server.BaseSelendroidServerHandler;
import io.selendroid.server.Response;
import io.selendroid.server.UiResponse;
import io.selendroid.server.inspector.BaseInspectorViewRenderer;
import io.selendroid.server.model.ActiveSession;
import java.util.logging.Logger;
import org.json.JSONException;
import org.webbitserver.HttpRequest;

public class InspectorUiHandler
extends BaseSelendroidServerHandler {
    private static final Logger log = Logger.getLogger(InspectorUiHandler.class.getName());

    public InspectorUiHandler(String mappedUri) {
        super(mappedUri);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Response handle(HttpRequest request) throws JSONException {
        ActiveSession session;
        String sessionId = this.getSessionId(request);
        log.info("inspector command, sessionId: " + sessionId);
        if (sessionId == null || sessionId.isEmpty()) {
            if (this.getSelendroidDriver(request).getActiveSessions() == null || this.getSelendroidDriver(request).getActiveSessions().size() < 1) return new UiResponse("", "Selendroid inspector can only be used if there is an active test session running. To start a test session, add a break point into your test code and run the test in debug mode.");
            session = this.getSelendroidDriver(request).getActiveSessions().get(0);
            log.info("Selected sessionId: " + session.getSessionKey());
            return new UiResponse(sessionId != null ? sessionId : "", new MyInspectorViewRenderer(session).buildHtml(request));
        } else {
            if (!this.getSelendroidDriver(request).isValidSession(sessionId)) return new UiResponse("", "You are using an invalid session key. Please open the inspector with the base uri: <IpAddress>:<Port>/inspector");
            session = this.getSelendroidDriver(request).getActiveSession(sessionId);
        }
        return new UiResponse(sessionId != null ? sessionId : "", new MyInspectorViewRenderer(session).buildHtml(request));
    }

    public class MyInspectorViewRenderer
    extends BaseInspectorViewRenderer {
        private ActiveSession session;

        public MyInspectorViewRenderer(ActiveSession session) {
            this.session = session;
        }

        @Override
        public String getResource(String name) {
            return "http://localhost:" + this.session.getSelendroidServerPort() + "/inspector/resources/" + name;
        }

        @Override
        public String getScreen(HttpRequest request) {
            return "http://" + request.header("Host") + "/inspector/session/" + this.session.getSessionKey() + "/screenshot";
        }
    }
}

