/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server;

import io.selendroid.server.Response;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.json.JSONException;
import org.json.JSONObject;

public class SelendroidResponse
implements Response {
    private String sessionId;
    private int status;
    private Object value;

    protected SelendroidResponse() {
    }

    public SelendroidResponse(String sessionId, int status, JSONObject value) {
        this.sessionId = sessionId;
        this.status = status;
        this.value = value;
    }

    public SelendroidResponse(String sessionId, int status, Exception e) throws JSONException {
        this.value = this.buildErrorValue(e);
        this.sessionId = sessionId;
        this.status = status;
    }

    public SelendroidResponse(String sessionId, Object value) {
        this.sessionId = sessionId;
        this.status = 0;
        this.value = value;
    }

    public SelendroidResponse(String sessionId, int status, Object value) {
        this.sessionId = sessionId;
        this.status = status;
        this.value = value;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    public int getStatus() {
        return this.status;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public String render() {
        JSONObject o = new JSONObject();
        try {
            if (this.sessionId != null) {
                o.put("sessionId", this.sessionId);
            }
            o.put("status", this.status);
            if (this.value != null) {
                o.put("value", this.value);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return o.toString();
    }

    private JSONObject buildErrorValue(Throwable t) throws JSONException {
        JSONObject errorValue = new JSONObject();
        errorValue.put("class", t.getClass().getCanonicalName());
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        errorValue.put("message", t.getMessage() + "\n" + stringWriter.toString());
        return errorValue;
    }
}

