/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.util.ArrayList;
import java.util.List;

public class SelendroidConfiguration {
    @Parameter(description="port the server will listen on.", names={"-port"})
    private int port = 4444;
    @Parameter(description="timeout that will be used to start Android emulators", names={"-timeoutEmulatorStart"})
    private long timeoutEmulatorStart = 300000L;
    @Parameter(description="location of the application under test. Absolute path to the apk", names={"-app", "-aut"})
    private List<String> supportedApps = new ArrayList<String>();
    @Parameter(names={"-verbose"}, description="Debug mode")
    private boolean verbose = false;
    @Parameter(names={"-emulatorPort"}, description="port number to start running emulators on")
    private int emulatorPort = 5560;
    @Parameter(names={"-deviceScreenshot"}, description="if true, screenshots will be taken on the device instead of using the ddmlib libary.")
    private boolean deviceScreenshot = false;
    @Parameter(description="the port the selendroid-standalone is using to communicate with instrumentation server", names={"-selendroidServerPort"})
    private int selendroidServerPort = 8080;
    @Parameter(description="The file of the keystore to be used", names={"-keystore"})
    private String keystore = null;
    @Parameter(description="The emulator options used for starting emulators: e.g. -no-audio", names={"-emulatorOptions"})
    private String emulatorOptions = null;
    @Parameter(description="if specified, will send a registration request to the given url. Example : http://localhost:4444/grid/register", names={"-hub"})
    private String registrationUrl = null;
    @Parameter(description="if specified, will specify the remote proxy to use on the grid. Example : io.selendroid.grid.SelendroidSessionProxy", names={"-proxy"})
    private String proxy = null;
    @Parameter(description="host of the node. Ip address needs to be specified for registering to a grid hub (guessing can be wrong complex).", names={"-host"})
    private String serverHost;
    @Parameter(names={"-keepAdbAlive"}, description="If true, adb will not be terminated on server shutdown.")
    private boolean keepAdbAlive = false;
    @Parameter(names={"-noWebviewApp"}, description="If you don't want selendroid to auto-extract and have 'AndroidDriver' (webview only app) available.")
    private boolean noWebViewApp = false;
    @Parameter(names={"-noClearData"}, description="When you quit the app, shell pm clear will not be called with this option specified.")
    private boolean noClearData = false;
    @Parameter(description="maximum session duration in seconds. Session will be forcefully terminated if it takes longer.", names={"-sessionTimeout"})
    private int sessionTimeoutSeconds = 1800;

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public void setSelendroidServerPort(int selendroidServerPort) {
        this.selendroidServerPort = selendroidServerPort;
    }

    public int getSelendroidServerPort() {
        return this.selendroidServerPort;
    }

    public void addSupportedApp(String appAbsolutPath) {
        this.supportedApps.add(appAbsolutPath);
    }

    public List<String> getSupportedApps() {
        return this.supportedApps;
    }

    public static SelendroidConfiguration create(String[] args) {
        SelendroidConfiguration res = new SelendroidConfiguration();
        new JCommander(res).parse(args);
        return res;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setEmulatorPort(int port) {
        this.emulatorPort = port;
    }

    public int getEmulatorPort() {
        return this.emulatorPort;
    }

    public long getTimeoutEmulatorStart() {
        return this.timeoutEmulatorStart;
    }

    public void setTimeoutEmulatorStart(long timeoutEmulatorStart) {
        this.timeoutEmulatorStart = timeoutEmulatorStart;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isDeviceScreenshot() {
        return this.deviceScreenshot;
    }

    public void setDeviceScreenshot(boolean deviceScreenshot) {
        this.deviceScreenshot = deviceScreenshot;
    }

    public String getRegistrationUrl() {
        return this.registrationUrl;
    }

    public void setRegistrationUrl(String registrationUrl) {
        this.registrationUrl = registrationUrl;
    }

    public String getProxy() {
        return this.proxy;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public void setServerHost(String serverHost) {
        this.serverHost = serverHost;
    }

    public String getEmulatorOptions() {
        return this.emulatorOptions;
    }

    public void setEmulatorOptions(String qemu) {
        this.emulatorOptions = qemu;
    }

    public boolean shouldKeepAdbAlive() {
        return this.keepAdbAlive;
    }

    public void setShouldKeepAdbAlive(boolean keepAdbAlive) {
        this.keepAdbAlive = keepAdbAlive;
    }

    public boolean isNoWebViewApp() {
        return this.noWebViewApp;
    }

    public void setNoWebViewApp(boolean noWebViewApp) {
        this.noWebViewApp = noWebViewApp;
    }

    public boolean isNoClearData() {
        return this.noClearData;
    }

    public void setNoClearData(boolean noClearData) {
        this.noClearData = noClearData;
    }

    public int getSessionTimeoutMillis() {
        return this.sessionTimeoutSeconds * 1000;
    }

    public void setSessionTimeoutSeconds(int sessionTimeoutSeconds) {
        this.sessionTimeoutSeconds = sessionTimeoutSeconds;
    }
}

