/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import com.thoughtworks.selenium.CommandProcessor;
import com.thoughtworks.selenium.HttpCommandProcessor;
import com.thoughtworks.selenium.Selenium;
import org.openqa.selenium.Capabilities;

public class DefaultSelenium
implements Selenium {
    protected CommandProcessor commandProcessor;

    public DefaultSelenium(String serverHost, int serverPort, String browserStartCommand, String browserURL) {
        this.commandProcessor = this.detectCommandProcessor(serverHost, serverPort, browserStartCommand, browserURL);
    }

    private CommandProcessor detectCommandProcessor(String serverHost, int serverPort, String browserStartCommand, String browserURL) {
        return new HttpCommandProcessor(serverHost, serverPort, browserStartCommand, browserURL);
    }

    public DefaultSelenium(CommandProcessor processor) {
        this.commandProcessor = processor;
    }

    @Override
    public void setExtensionJs(String extensionJs) {
        this.commandProcessor.setExtensionJs(extensionJs);
    }

    @Override
    public void start() {
        try {
            this.commandProcessor.start();
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message != null && message.startsWith("Connection refused")) {
                throw new RuntimeException("Could not contact Selenium Server; have you started it on '" + this.commandProcessor.getRemoteControlServerLocation() + "' ?\nRead more at http://seleniumhq.org/projects/remote-control/not-started.html\n" + e.getMessage());
            }
            throw new RuntimeException("Could not start Selenium session: " + e.getMessage(), e);
        }
    }

    @Override
    public void start(String optionsString) {
        try {
            this.commandProcessor.start(optionsString);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message != null && message.indexOf("Connection refused: connect") != -1) {
                throw new RuntimeException("Could not contact Selenium Server; have you started it?\n" + e.getMessage());
            }
            throw new RuntimeException("Could not start Selenium session: " + e.getMessage(), e);
        }
    }

    @Override
    public void start(Object optionsObject) {
        if (optionsObject instanceof Capabilities) {
            Object id = ((Capabilities)optionsObject).getCapability("webdriver.remote.sessionid");
            this.start("webdriver.remote.sessionid=" + id);
        } else {
            this.start(optionsObject.toString());
        }
    }

    @Override
    public void stop() {
        this.commandProcessor.stop();
    }

    @Override
    public void showContextualBanner() {
        try {
            StackTraceElement[] e = Thread.currentThread().getStackTrace();
            String className = null;
            String methodName = null;
            for (int i = 0; i < e.length; ++i) {
                if (e[i].getClassName().equals("java.lang.Thread") || e[i].getMethodName().equals("showContextualBanner")) continue;
                className = e[i].getClassName();
                methodName = e[i].getMethodName();
                break;
            }
            this.showContextualBanner(className, methodName);
        }
        catch (Exception e) {
            this.setContext("<unknown context>");
        }
    }

    @Override
    public void showContextualBanner(String className, String methodName) {
        StringBuilder context = new StringBuilder().append(className).append(": ");
        boolean lastOneWasUpperCase = false;
        boolean nextOneIsUpperCase = false;
        int len = methodName.length();
        for (int i = 0; i < len; ++i) {
            char ch = methodName.charAt(i);
            boolean bl = nextOneIsUpperCase = i < len - 1 ? Character.isUpperCase(methodName.charAt(i + 1)) : true;
            if (!(!Character.isUpperCase(ch) || lastOneWasUpperCase && nextOneIsUpperCase)) {
                context.append(" ");
                lastOneWasUpperCase = true;
            }
            if (!Character.isUpperCase(ch)) {
                lastOneWasUpperCase = false;
            }
            context.append(ch);
        }
        this.setContext(context.toString());
    }

    @Override
    public void click(String locator) {
        this.commandProcessor.doCommand("click", new String[]{locator});
    }

    @Override
    public void doubleClick(String locator) {
        this.commandProcessor.doCommand("doubleClick", new String[]{locator});
    }

    @Override
    public void contextMenu(String locator) {
        this.commandProcessor.doCommand("contextMenu", new String[]{locator});
    }

    @Override
    public void clickAt(String locator, String coordString) {
        this.commandProcessor.doCommand("clickAt", new String[]{locator, coordString});
    }

    @Override
    public void doubleClickAt(String locator, String coordString) {
        this.commandProcessor.doCommand("doubleClickAt", new String[]{locator, coordString});
    }

    @Override
    public void contextMenuAt(String locator, String coordString) {
        this.commandProcessor.doCommand("contextMenuAt", new String[]{locator, coordString});
    }

    @Override
    public void fireEvent(String locator, String eventName) {
        this.commandProcessor.doCommand("fireEvent", new String[]{locator, eventName});
    }

    @Override
    public void focus(String locator) {
        this.commandProcessor.doCommand("focus", new String[]{locator});
    }

    @Override
    public void keyPress(String locator, String keySequence) {
        this.commandProcessor.doCommand("keyPress", new String[]{locator, keySequence});
    }

    @Override
    public void shiftKeyDown() {
        this.commandProcessor.doCommand("shiftKeyDown", new String[0]);
    }

    @Override
    public void shiftKeyUp() {
        this.commandProcessor.doCommand("shiftKeyUp", new String[0]);
    }

    @Override
    public void metaKeyDown() {
        this.commandProcessor.doCommand("metaKeyDown", new String[0]);
    }

    @Override
    public void metaKeyUp() {
        this.commandProcessor.doCommand("metaKeyUp", new String[0]);
    }

    @Override
    public void altKeyDown() {
        this.commandProcessor.doCommand("altKeyDown", new String[0]);
    }

    @Override
    public void altKeyUp() {
        this.commandProcessor.doCommand("altKeyUp", new String[0]);
    }

    @Override
    public void controlKeyDown() {
        this.commandProcessor.doCommand("controlKeyDown", new String[0]);
    }

    @Override
    public void controlKeyUp() {
        this.commandProcessor.doCommand("controlKeyUp", new String[0]);
    }

    @Override
    public void keyDown(String locator, String keySequence) {
        this.commandProcessor.doCommand("keyDown", new String[]{locator, keySequence});
    }

    @Override
    public void keyUp(String locator, String keySequence) {
        this.commandProcessor.doCommand("keyUp", new String[]{locator, keySequence});
    }

    @Override
    public void mouseOver(String locator) {
        this.commandProcessor.doCommand("mouseOver", new String[]{locator});
    }

    @Override
    public void mouseOut(String locator) {
        this.commandProcessor.doCommand("mouseOut", new String[]{locator});
    }

    @Override
    public void mouseDown(String locator) {
        this.commandProcessor.doCommand("mouseDown", new String[]{locator});
    }

    @Override
    public void mouseDownRight(String locator) {
        this.commandProcessor.doCommand("mouseDownRight", new String[]{locator});
    }

    @Override
    public void mouseDownAt(String locator, String coordString) {
        this.commandProcessor.doCommand("mouseDownAt", new String[]{locator, coordString});
    }

    @Override
    public void mouseDownRightAt(String locator, String coordString) {
        this.commandProcessor.doCommand("mouseDownRightAt", new String[]{locator, coordString});
    }

    @Override
    public void mouseUp(String locator) {
        this.commandProcessor.doCommand("mouseUp", new String[]{locator});
    }

    @Override
    public void mouseUpRight(String locator) {
        this.commandProcessor.doCommand("mouseUpRight", new String[]{locator});
    }

    @Override
    public void mouseUpAt(String locator, String coordString) {
        this.commandProcessor.doCommand("mouseUpAt", new String[]{locator, coordString});
    }

    @Override
    public void mouseUpRightAt(String locator, String coordString) {
        this.commandProcessor.doCommand("mouseUpRightAt", new String[]{locator, coordString});
    }

    @Override
    public void mouseMove(String locator) {
        this.commandProcessor.doCommand("mouseMove", new String[]{locator});
    }

    @Override
    public void mouseMoveAt(String locator, String coordString) {
        this.commandProcessor.doCommand("mouseMoveAt", new String[]{locator, coordString});
    }

    @Override
    public void type(String locator, String value) {
        this.commandProcessor.doCommand("type", new String[]{locator, value});
    }

    @Override
    public void typeKeys(String locator, String value) {
        this.commandProcessor.doCommand("typeKeys", new String[]{locator, value});
    }

    @Override
    public void setSpeed(String value) {
        this.commandProcessor.doCommand("setSpeed", new String[]{value});
    }

    @Override
    public String getSpeed() {
        return this.commandProcessor.getString("getSpeed", new String[0]);
    }

    @Override
    public String getLog() {
        return this.commandProcessor.getString("getLog", new String[0]);
    }

    @Override
    public void check(String locator) {
        this.commandProcessor.doCommand("check", new String[]{locator});
    }

    @Override
    public void uncheck(String locator) {
        this.commandProcessor.doCommand("uncheck", new String[]{locator});
    }

    @Override
    public void select(String selectLocator, String optionLocator) {
        this.commandProcessor.doCommand("select", new String[]{selectLocator, optionLocator});
    }

    @Override
    public void addSelection(String locator, String optionLocator) {
        this.commandProcessor.doCommand("addSelection", new String[]{locator, optionLocator});
    }

    @Override
    public void removeSelection(String locator, String optionLocator) {
        this.commandProcessor.doCommand("removeSelection", new String[]{locator, optionLocator});
    }

    @Override
    public void removeAllSelections(String locator) {
        this.commandProcessor.doCommand("removeAllSelections", new String[]{locator});
    }

    @Override
    public void submit(String formLocator) {
        this.commandProcessor.doCommand("submit", new String[]{formLocator});
    }

    @Override
    public void open(String url, String ignoreResponseCode) {
        this.commandProcessor.doCommand("open", new String[]{url, ignoreResponseCode});
    }

    @Override
    public void open(String url) {
        this.commandProcessor.doCommand("open", new String[]{url});
    }

    @Override
    public void openWindow(String url, String windowID) {
        this.commandProcessor.doCommand("openWindow", new String[]{url, windowID});
    }

    @Override
    public void selectWindow(String windowID) {
        this.commandProcessor.doCommand("selectWindow", new String[]{windowID});
    }

    @Override
    public void selectPopUp(String windowID) {
        this.commandProcessor.doCommand("selectPopUp", new String[]{windowID});
    }

    @Override
    public void deselectPopUp() {
        this.commandProcessor.doCommand("deselectPopUp", new String[0]);
    }

    @Override
    public void selectFrame(String locator) {
        this.commandProcessor.doCommand("selectFrame", new String[]{locator});
    }

    @Override
    public boolean getWhetherThisFrameMatchFrameExpression(String currentFrameString, String target) {
        return this.commandProcessor.getBoolean("getWhetherThisFrameMatchFrameExpression", new String[]{currentFrameString, target});
    }

    @Override
    public boolean getWhetherThisWindowMatchWindowExpression(String currentWindowString, String target) {
        return this.commandProcessor.getBoolean("getWhetherThisWindowMatchWindowExpression", new String[]{currentWindowString, target});
    }

    @Override
    public void waitForPopUp(String windowID, String timeout) {
        this.commandProcessor.doCommand("waitForPopUp", new String[]{windowID, timeout});
    }

    @Override
    public void chooseCancelOnNextConfirmation() {
        this.commandProcessor.doCommand("chooseCancelOnNextConfirmation", new String[0]);
    }

    @Override
    public void chooseOkOnNextConfirmation() {
        this.commandProcessor.doCommand("chooseOkOnNextConfirmation", new String[0]);
    }

    @Override
    public void answerOnNextPrompt(String answer) {
        this.commandProcessor.doCommand("answerOnNextPrompt", new String[]{answer});
    }

    @Override
    public void goBack() {
        this.commandProcessor.doCommand("goBack", new String[0]);
    }

    @Override
    public void refresh() {
        this.commandProcessor.doCommand("refresh", new String[0]);
    }

    @Override
    public void close() {
        this.commandProcessor.doCommand("close", new String[0]);
    }

    @Override
    public boolean isAlertPresent() {
        return this.commandProcessor.getBoolean("isAlertPresent", new String[0]);
    }

    @Override
    public boolean isPromptPresent() {
        return this.commandProcessor.getBoolean("isPromptPresent", new String[0]);
    }

    @Override
    public boolean isConfirmationPresent() {
        return this.commandProcessor.getBoolean("isConfirmationPresent", new String[0]);
    }

    @Override
    public String getAlert() {
        return this.commandProcessor.getString("getAlert", new String[0]);
    }

    @Override
    public String getConfirmation() {
        return this.commandProcessor.getString("getConfirmation", new String[0]);
    }

    @Override
    public String getPrompt() {
        return this.commandProcessor.getString("getPrompt", new String[0]);
    }

    @Override
    public String getLocation() {
        return this.commandProcessor.getString("getLocation", new String[0]);
    }

    @Override
    public String getTitle() {
        return this.commandProcessor.getString("getTitle", new String[0]);
    }

    @Override
    public String getBodyText() {
        return this.commandProcessor.getString("getBodyText", new String[0]);
    }

    @Override
    public String getValue(String locator) {
        return this.commandProcessor.getString("getValue", new String[]{locator});
    }

    @Override
    public String getText(String locator) {
        return this.commandProcessor.getString("getText", new String[]{locator});
    }

    @Override
    public void highlight(String locator) {
        this.commandProcessor.doCommand("highlight", new String[]{locator});
    }

    @Override
    public String getEval(String script) {
        return this.commandProcessor.getString("getEval", new String[]{script});
    }

    @Override
    public boolean isChecked(String locator) {
        return this.commandProcessor.getBoolean("isChecked", new String[]{locator});
    }

    @Override
    public String getTable(String tableCellAddress) {
        return this.commandProcessor.getString("getTable", new String[]{tableCellAddress});
    }

    @Override
    public String[] getSelectedLabels(String selectLocator) {
        return this.commandProcessor.getStringArray("getSelectedLabels", new String[]{selectLocator});
    }

    @Override
    public String getSelectedLabel(String selectLocator) {
        return this.commandProcessor.getString("getSelectedLabel", new String[]{selectLocator});
    }

    @Override
    public String[] getSelectedValues(String selectLocator) {
        return this.commandProcessor.getStringArray("getSelectedValues", new String[]{selectLocator});
    }

    @Override
    public String getSelectedValue(String selectLocator) {
        return this.commandProcessor.getString("getSelectedValue", new String[]{selectLocator});
    }

    @Override
    public String[] getSelectedIndexes(String selectLocator) {
        return this.commandProcessor.getStringArray("getSelectedIndexes", new String[]{selectLocator});
    }

    @Override
    public String getSelectedIndex(String selectLocator) {
        return this.commandProcessor.getString("getSelectedIndex", new String[]{selectLocator});
    }

    @Override
    public String[] getSelectedIds(String selectLocator) {
        return this.commandProcessor.getStringArray("getSelectedIds", new String[]{selectLocator});
    }

    @Override
    public String getSelectedId(String selectLocator) {
        return this.commandProcessor.getString("getSelectedId", new String[]{selectLocator});
    }

    @Override
    public boolean isSomethingSelected(String selectLocator) {
        return this.commandProcessor.getBoolean("isSomethingSelected", new String[]{selectLocator});
    }

    @Override
    public String[] getSelectOptions(String selectLocator) {
        return this.commandProcessor.getStringArray("getSelectOptions", new String[]{selectLocator});
    }

    @Override
    public String getAttribute(String attributeLocator) {
        return this.commandProcessor.getString("getAttribute", new String[]{attributeLocator});
    }

    @Override
    public boolean isTextPresent(String pattern) {
        return this.commandProcessor.getBoolean("isTextPresent", new String[]{pattern});
    }

    @Override
    public boolean isElementPresent(String locator) {
        return this.commandProcessor.getBoolean("isElementPresent", new String[]{locator});
    }

    @Override
    public boolean isVisible(String locator) {
        return this.commandProcessor.getBoolean("isVisible", new String[]{locator});
    }

    @Override
    public boolean isEditable(String locator) {
        return this.commandProcessor.getBoolean("isEditable", new String[]{locator});
    }

    @Override
    public String[] getAllButtons() {
        return this.commandProcessor.getStringArray("getAllButtons", new String[0]);
    }

    @Override
    public String[] getAllLinks() {
        return this.commandProcessor.getStringArray("getAllLinks", new String[0]);
    }

    @Override
    public String[] getAllFields() {
        return this.commandProcessor.getStringArray("getAllFields", new String[0]);
    }

    @Override
    public String[] getAttributeFromAllWindows(String attributeName) {
        return this.commandProcessor.getStringArray("getAttributeFromAllWindows", new String[]{attributeName});
    }

    @Override
    public void dragdrop(String locator, String movementsString) {
        this.commandProcessor.doCommand("dragdrop", new String[]{locator, movementsString});
    }

    @Override
    public void setMouseSpeed(String pixels) {
        this.commandProcessor.doCommand("setMouseSpeed", new String[]{pixels});
    }

    @Override
    public Number getMouseSpeed() {
        return this.commandProcessor.getNumber("getMouseSpeed", new String[0]);
    }

    @Override
    public void dragAndDrop(String locator, String movementsString) {
        this.commandProcessor.doCommand("dragAndDrop", new String[]{locator, movementsString});
    }

    @Override
    public void dragAndDropToObject(String locatorOfObjectToBeDragged, String locatorOfDragDestinationObject) {
        this.commandProcessor.doCommand("dragAndDropToObject", new String[]{locatorOfObjectToBeDragged, locatorOfDragDestinationObject});
    }

    @Override
    public void windowFocus() {
        this.commandProcessor.doCommand("windowFocus", new String[0]);
    }

    @Override
    public void windowMaximize() {
        this.commandProcessor.doCommand("windowMaximize", new String[0]);
    }

    @Override
    public String[] getAllWindowIds() {
        return this.commandProcessor.getStringArray("getAllWindowIds", new String[0]);
    }

    @Override
    public String[] getAllWindowNames() {
        return this.commandProcessor.getStringArray("getAllWindowNames", new String[0]);
    }

    @Override
    public String[] getAllWindowTitles() {
        return this.commandProcessor.getStringArray("getAllWindowTitles", new String[0]);
    }

    @Override
    public String getHtmlSource() {
        return this.commandProcessor.getString("getHtmlSource", new String[0]);
    }

    @Override
    public void setCursorPosition(String locator, String position) {
        this.commandProcessor.doCommand("setCursorPosition", new String[]{locator, position});
    }

    @Override
    public Number getElementIndex(String locator) {
        return this.commandProcessor.getNumber("getElementIndex", new String[]{locator});
    }

    @Override
    public boolean isOrdered(String locator1, String locator2) {
        return this.commandProcessor.getBoolean("isOrdered", new String[]{locator1, locator2});
    }

    @Override
    public Number getElementPositionLeft(String locator) {
        return this.commandProcessor.getNumber("getElementPositionLeft", new String[]{locator});
    }

    @Override
    public Number getElementPositionTop(String locator) {
        return this.commandProcessor.getNumber("getElementPositionTop", new String[]{locator});
    }

    @Override
    public Number getElementWidth(String locator) {
        return this.commandProcessor.getNumber("getElementWidth", new String[]{locator});
    }

    @Override
    public Number getElementHeight(String locator) {
        return this.commandProcessor.getNumber("getElementHeight", new String[]{locator});
    }

    @Override
    public Number getCursorPosition(String locator) {
        return this.commandProcessor.getNumber("getCursorPosition", new String[]{locator});
    }

    @Override
    public String getExpression(String expression) {
        return this.commandProcessor.getString("getExpression", new String[]{expression});
    }

    @Override
    public Number getXpathCount(String xpath) {
        return this.commandProcessor.getNumber("getXpathCount", new String[]{xpath});
    }

    @Override
    public Number getCssCount(String css) {
        return this.commandProcessor.getNumber("getCssCount", new String[]{css});
    }

    @Override
    public void assignId(String locator, String identifier) {
        this.commandProcessor.doCommand("assignId", new String[]{locator, identifier});
    }

    @Override
    public void allowNativeXpath(String allow) {
        this.commandProcessor.doCommand("allowNativeXpath", new String[]{allow});
    }

    @Override
    public void ignoreAttributesWithoutValue(String ignore) {
        this.commandProcessor.doCommand("ignoreAttributesWithoutValue", new String[]{ignore});
    }

    @Override
    public void waitForCondition(String script, String timeout) {
        this.commandProcessor.doCommand("waitForCondition", new String[]{script, timeout});
    }

    @Override
    public void setTimeout(String timeout) {
        this.commandProcessor.doCommand("setTimeout", new String[]{timeout});
    }

    @Override
    public void waitForPageToLoad(String timeout) {
        this.commandProcessor.doCommand("waitForPageToLoad", new String[]{timeout});
    }

    @Override
    public void waitForFrameToLoad(String frameAddress, String timeout) {
        this.commandProcessor.doCommand("waitForFrameToLoad", new String[]{frameAddress, timeout});
    }

    @Override
    public String getCookie() {
        return this.commandProcessor.getString("getCookie", new String[0]);
    }

    @Override
    public String getCookieByName(String name) {
        return this.commandProcessor.getString("getCookieByName", new String[]{name});
    }

    @Override
    public boolean isCookiePresent(String name) {
        return this.commandProcessor.getBoolean("isCookiePresent", new String[]{name});
    }

    @Override
    public void createCookie(String nameValuePair, String optionsString) {
        this.commandProcessor.doCommand("createCookie", new String[]{nameValuePair, optionsString});
    }

    @Override
    public void deleteCookie(String name, String optionsString) {
        this.commandProcessor.doCommand("deleteCookie", new String[]{name, optionsString});
    }

    @Override
    public void deleteAllVisibleCookies() {
        this.commandProcessor.doCommand("deleteAllVisibleCookies", new String[0]);
    }

    @Override
    public void setBrowserLogLevel(String logLevel) {
        this.commandProcessor.doCommand("setBrowserLogLevel", new String[]{logLevel});
    }

    @Override
    public void runScript(String script) {
        this.commandProcessor.doCommand("runScript", new String[]{script});
    }

    @Override
    public void addLocationStrategy(String strategyName, String functionDefinition) {
        this.commandProcessor.doCommand("addLocationStrategy", new String[]{strategyName, functionDefinition});
    }

    @Override
    public void captureEntirePageScreenshot(String filename, String kwargs) {
        this.commandProcessor.doCommand("captureEntirePageScreenshot", new String[]{filename, kwargs});
    }

    @Override
    public void rollup(String rollupName, String kwargs) {
        this.commandProcessor.doCommand("rollup", new String[]{rollupName, kwargs});
    }

    @Override
    public void addScript(String scriptContent, String scriptTagId) {
        this.commandProcessor.doCommand("addScript", new String[]{scriptContent, scriptTagId});
    }

    @Override
    public void removeScript(String scriptTagId) {
        this.commandProcessor.doCommand("removeScript", new String[]{scriptTagId});
    }

    @Override
    public void useXpathLibrary(String libraryName) {
        this.commandProcessor.doCommand("useXpathLibrary", new String[]{libraryName});
    }

    @Override
    public void setContext(String context) {
        this.commandProcessor.doCommand("setContext", new String[]{context});
    }

    @Override
    public void attachFile(String fieldLocator, String fileLocator) {
        this.commandProcessor.doCommand("attachFile", new String[]{fieldLocator, fileLocator});
    }

    @Override
    public void captureScreenshot(String filename) {
        this.commandProcessor.doCommand("captureScreenshot", new String[]{filename});
    }

    @Override
    public String captureScreenshotToString() {
        return this.commandProcessor.getString("captureScreenshotToString", new String[0]);
    }

    @Override
    public String captureNetworkTraffic(String type) {
        return this.commandProcessor.getString("captureNetworkTraffic", new String[]{type});
    }

    @Override
    public void addCustomRequestHeader(String key, String value) {
        this.commandProcessor.getString("addCustomRequestHeader", new String[]{key, value});
    }

    @Override
    public String captureEntirePageScreenshotToString(String kwargs) {
        return this.commandProcessor.getString("captureEntirePageScreenshotToString", new String[]{kwargs});
    }

    @Override
    public void shutDownSeleniumServer() {
        this.commandProcessor.doCommand("shutDownSeleniumServer", new String[0]);
    }

    @Override
    public String retrieveLastRemoteControlLogs() {
        return this.commandProcessor.getString("retrieveLastRemoteControlLogs", new String[0]);
    }

    @Override
    public void keyDownNative(String keycode) {
        this.commandProcessor.doCommand("keyDownNative", new String[]{keycode});
    }

    @Override
    public void keyUpNative(String keycode) {
        this.commandProcessor.doCommand("keyUpNative", new String[]{keycode});
    }

    @Override
    public void keyPressNative(String keycode) {
        this.commandProcessor.doCommand("keyPressNative", new String[]{keycode});
    }
}

