from suds.client import Client
import urllib2


class SoapRequestor(object):
    """
    Helper class to contruct and send SOAP requests
    """

    client = None       #: client object for making calls and receiving responses
    api_wsdl = ""        #: WSDL file url / location to define calls
    logger = None       #: logger to send loggin information to.  Logger comes from pytest test definitions
    my_doctor = None    #: suds Doctor to fix any issues with the wsdl definition

    def __init__(self, logger, wsdl, the_doctor=None):
        """
        Constructor for class

        Args :
        logger : (logger) instance of a logging object configured in testing project
        wsdl : (str) URL to the location of the wsdl file
        doctor : (ImportDoctor) instance of the suds.xsd.doctor.ImportDoctor class for fixing broken schemas

        """

        self.logger = logger
        self.api_wsdl = wsdl
        self.my_doctor = the_doctor
        self.create_client();


    def create_client(self):

        try:

            self.client = Client(self.api_wsdl, doctor=self.my_doctor)
        except urllib2.URLError, e:
            print str(e)

    def get_methods(self):
        """
        Fetches a list of method objects from the wsdl and returns them in a list

        Returns: (list) of suds Method objects containing all information on calling method and handling the response.

        """
        methods = self.client.wsdl.services[0].ports[0].methods.values()

        return methods


# # #create logger
# logger = logging.getLogger('test')
# logger.setLevel(logging.DEBUG)

# # create console handler and set level to debug
# ch = logging.StreamHandler()
# ch.setLevel(logging.DEBUG)

# # create formatter
# formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')

# # add formatter to ch
# ch.setFormatter(formatter)

# #add ch to logger
# logger.addHandler(ch)
# logging.basicConfig(level=logging.INFO)
# logging.getLogger('suds.client').setLevel(logging.DEBUG)
# logging.getLogger('suds.transport').setLevel(logging.DEBUG)
# logging.getLogger('suds.xsd.schema').setLevel(logging.DEBUG)
# logging.getLogger('suds.wsdl').setLevel(logging.DEBUG)

#wsdl = "http://mtljiraqcprod01.ad.ypg.com/SpiraTeam/Services/v4_0/ImportExport.svc?wsdl"
# wsdl = "http://localhost/GetAccountsWithMerchants.WSDL"
# my_soap = SoapRequestor(logger,wsdl)


# #resp = my_soap.client.set_options(service='YPG_spcGet_spcAccounts_spcWith_spcMerchants',port='GetAccounts')
# #print my_soap.client

# methods = my_soap.getMethods()
# print methods

# for method in my_soap.client.wsdl.services[0].ports[0].methods.values():
#     print '%s(%s)' % (method.name, ', '.join('%s: %s' % (part.type, part.name) for part in method.soap.input.body.parts))


#print  methods[0]
#services = my_soap.client.service
#myAccount = my_soap.client.factory.create(u'xsdLocal0:Account')
#myAccount.AccountNum="3333333"
#print myAccount


#print my_soap.client.wsdl.services[0].ports[0].methods.values()[0].soap.input.body.parts
#print services.GetAccounts("Y","","","","4164662766","")
# try :

# 	resp = my_soap.client.service.GetAccounts("Y","","","","4164662766","")

# except suds.WebFault, e:
# 	print str(e)

# print my_soap.client.last_sent()
#print resp


