import os
from setuptools import setup, find_packages
import sys


def get_version_filename():
    """
    Return full filename where package version number is stored
    """
    parent_dir = os.path.dirname(__file__)
    return os.path.abspath(os.path.join(parent_dir, "VERSION.txt"))


def get_version():
    """
    Returns package's version number.\n
    Version is read from file VERSION.txt (or file returned by get_version_filename())
    """
    try:
        f = open(get_version_filename(), 'r')
        try:
            #Get version from file, removing carriage return
            version = f.read().strip()
            return version
        finally:
            f.close()
    except IOError:
        sys.stderr.write("File %s doesn't exist. Can't get package version" % get_version_filename())
        exit(-1)


#Get requirements from requirements.txt file
def get_requirements():
    with open('requirements.txt') as f:
        install_requires = f.readlines()

    #Remove "\n" from each item
    requirements = map(lambda s: s.strip(), install_requires)
    return requirements


setup(
    name='tlib',
    version=get_version(),
    packages=find_packages(),
    author='Quality Assurance Automation @ Yellow Pages Group',
    description="""Packages to help the wayward QA tester.
        Contains :
            - HttpRequestor : Facilitates communication to REST APIs
            - SoapRequestor : Facilitates communication to SOAP APIs
            - SpiraModerator : Fetches and updates data from SpiraTeam
            - JiraModerator : Fetches and updates issues in Jira
            - WtpHelper : Sends test requests to WebPagetest and returns test results
            """,
    install_requires=get_requirements(),
    # the following makes a plugin available to py.test
    entry_points={
        'pytest11': [
            'selenium = pytest_auto.selenium_plugin',
            'yp_auto = pytest_auto.yp_auto',
        ]
    },
    package_data={'tlib': ['asset/*.*',
                           'asset/selenium/*.*',
                           'asset/selenium/IE/Win32_2.39.0/*.*',
                           'asset/selenium/IE/x64_2.39.0/*.*',
                           'asset/wpt_batch_lib/*.*',
                           'config/*.*',
                           'templates/*.*']},
)

