import os
import csv
from ExceptionHelper import FileNotExistError


class CsvHelper(object):

    _data = []
    _path = None

    def __init__(self, path):
        """
        Constructor for class

        @param path : path to the excel file
        @param isFirstRowHeader : is the first row of the excel file a header row?
                If true, the return result for reach row will be dictionary, otherwise, it will be a list
        """
        if not os.access(path, os.F_OK):
            raise FileNotExistError('Cannot find the csv file [%s]' % path)
        self._path = path
        self.csv2dict()

    def csv2dict(self):
        """
        Convert csv data to lists, the result will be stored in data attribute
        """
        with open(self._path, 'rb') as f:
            rows = csv.DictReader(f)
            for row in rows:
                self._data.append(row)

    @property
    def data(self):
        """
        The csv data extracted from the file
        """
        return self._data
