"""
Pytest plugin with commonly used fixtures
"""
import os
import pytest
import logging
import logging.config
from tlib.base import TestHelper

# noinspection PyShadowingNames
@pytest.fixture(scope='session')
def tlib_logger(request):
    """
    Returns logger with name tlib.\n
    Logger will get flushed at the end to ensure data is not lost fi tests exist abnormally
    """
    config_folder = TestHelper.tlib_config_folder()
    try:
        logging.config.fileConfig(os.path.join(config_folder, "logging.conf"))
    except IOError:
        pytest.fail("Couldn't create logger object. Make sure log folder exists and " \
                    "you have write permissions")
    return logging.getLogger("tlib")


# noinspection PyShadowingNames
@pytest.fixture(scope='session')
def adb_logger(request):
    """
    Returns logger with name adb\n
    Logger will get flushed at the end to ensure data is not lost fi tests exist abnormally
    """
    config_folder = TestHelper.tlib_config_folder()
    try:
        logging.config.fileConfig(os.path.join(config_folder, "logging.conf"))
    except IOError:
        pytest.fail("Couldn't create logger object. Make sure log folder exists and " \
                    "you have write permissions")
    return logging.getLogger("adb")


# noinspection PyShadowingNames
@pytest.fixture(scope='session')
def test_logger(request):
    """
    Returns logger with name test\n
    Logger will get flushed at the end to ensure data is not lost fi tests exist abnormally
    """
    config_folder = TestHelper.tlib_config_folder()
    try:
        logging.config.fileConfig(os.path.join(config_folder, "logging.conf"))
    except IOError:
        pytest.fail("Couldn't create logger object. Make sure log folder exists and " \
                    "you have write permissions")
    return logging.getLogger("test")
