import logging
import logging.config
from tlib.base import TestHelper

def get_tlib_logger():
    """
    Returns logger named tlib.\n
    This logger should only be used by TLib modules. To log from a test or test module use get_test_logger\n
    Logger will get flushed at the end to ensure data is not lost if tests exist abnormally
    """
    config_folder = TestHelper.tlib_config_folder()
    try:
        logging.config.fileConfig(os.path.join(config_folder, "logging.conf"))
    except IOError:
        raise IOError("Couldn't create logger object. Make sure log folder exists and " \
                    "you have write permissions")

    return logging.getLogger("tlib")

def get_adb_logger():
    """
    Returns logger named adb.\n
    This logger should only be used by adb modules. To log from a test or test module use get_test_logger\n
    Logger will get flushed at the end to ensure data is not lost if tests exist abnormally
    """
    config_folder = TestHelper.adb_config_folder()
    try:
        logging.config.fileConfig(os.path.join(config_folder, "logging.conf"))
    except IOError:
        raise IOError("Couldn't create logger object. Make sure log folder exists and " \
                    "you have write permissions")

    return logging.getLogger("adb")

def get_test_logger():
    """
    Returns logger named test.\n
    This logger should only be used by test modules. To log from a test or test module use get_test_logger\n
    Logger will get flushed at the end to ensure data is not lost if tests exist abnormally
    """
    config_folder = TestHelper.test_config_folder()
    try:
        logging.config.fileConfig(os.path.join(config_folder, "logging.conf"))
    except IOError:
        raise IOError("Couldn't create logger object. Make sure log folder exists and " \
                    "you have write permissions")

    return logging.getLogger("test")
