/***
|''Name''|TiddlySpaceRevertRevision|
|''Description''|Revert to a previous revision|
|''Author''|BenGillies|
|''Version''|0.1|
|''Status''|unstable|
|''Source''|http://github.com/TiddlySpace/tiddlyspace|
|''CodeRepository''|http://github.com/TiddlySpace/tiddlyspace|
|''License''|[[BSD|http://www.opensource.org/licenses/bsd-license.php]]|
|''CoreVersion''|2.6.0|
|''Requires''|TiddlyWebAdaptor TiddlySpaceRevisionView|
!Usage
Add a control button to revert to a particular revision.

The button must be called from within a revision, as generated by TiddlySpaceRevisionView
!Code
***/
//{{{
(function($) {

config.commands.revert = {
	text: "revert",
	tooltip: "make this revision the current one",
	handler: function(ev, src, title) {
		var revElem = story.getTiddler(title);
		var tidToRevert = store.getTiddler($(revElem).attr("revName"));

		var revision = store.getTiddler(title);
		if ((revision) && (tidToRevert)) {
			tidToRevert.text = revision.text;
			var newFields = merge({}, revision.fields);
			for (var fieldName in newFields) {
				if (fieldName.substr(0, 7) === "server.") {
					delete newFields[fieldName];
				}
			}
			merge(tidToRevert.fields, newFields);
			tidToRevert.tags = merge([], revision.tags);
			tidToRevert.fields.changecount = 1;
			delete tidToRevert.fields.doNotSave;

			store.saveTiddler(tidToRevert.title, tidToRevert.title,
				tidToRevert.text, null, null, tidToRevert.tags,
				tidToRevert.fields, false, tidToRevert.created, tidToRevert.creator);

			autoSaveChanges(true);
		}
	}
};

})(jQuery);
//}}}
