# coding: utf-8
from twisted.trial import unittest

import os
import shutil
import ConfigParser

from twisted.trial import unittest
from twisted.internet import defer

from sdfs.utils import *
from sdfs.enum import DatabaseType

class UtilsTest(unittest.TestCase):
    def testCleanupPath(self):
        self.failUnlessEqual(cleanup_path('/some/path/'), 'some/path',
                             'Does not strip slashes correctly on single input')
        self.failUnlessEqual(cleanup_path(['/some/path', '/another/', 'this/is/very/long/']),
                             ['some/path', 'another', 'this/is/very/long'],
                             'Does not strip slashes correctly on list')
    
    def testHashPath(self):
        self.failUnlessEqual(hash_path('some/path'),
                             '\xcf\xb9\xa6\x14\x14YZ\x0cW\xf5=\x97\xf92\xb6\xf3\xf3OUJ',
                             'Does not hash path correctly')
    
    def testKeyify(self):
        self.failUnlessEqual(keyify(DatabaseType.FILE, 'some/path/file'),
                             '\x00\x84\xbd\x8a^+R\xe6\xa99\x84\xec\xb6\x11\x86\r\xb2\x14x\xf1x',
                             'Does not keyify file correctly')
        self.failUnlessEqual(keyify(DatabaseType.DIRECTORY, 'some/path'),
                             '\x01\xcf\xb9\xa6\x14\x14YZ\x0cW\xf5=\x97\xf92\xb6\xf3\xf3OUJ',
                             'Does not keyify directory correctly')
    
    def testParseAcceptHeader(self):
        self.failUnlessEqual(parse_accept_header('text/*;q=0.3, text/html;q=0.7, text/html;level=1, text/html;level=2;q=0.4, */*;q=0.5'),
                             [('text/html', 1), ('text/html', 1), ('text/html', 0.7), ('*/*', 0.5), ('text/*', 0.3)],
                             'Does not parse and sort very elaborate example correctly')
        self.failUnlessEqual(parse_accept_header('text/html; q=0.5, application/json'), [('application/json', 1), ('text/html', 0.5)],
                                                 'Does not parse good example correctly')