import os
import shutil
import ConfigParser

from twisted.trial import unittest
from twisted.internet import defer

from sdfs.server import SDFSServer

class FileSystemScannerTest(unittest.TestCase):
    def setUp(self):
        tmpfolder = os.path.join(os.getcwd(), self.mktemp())
        os.mkdir(tmpfolder)
        self.tmpfolder = tmpfolder
        
        self.dbfolder = dbfolder = os.path.join(os.getcwd(), self.mktemp())
        os.mkdir(dbfolder)
        
        self.folder1 = os.path.join(tmpfolder, 'tmp1') + os.sep
        self.folder2 = os.path.join(tmpfolder, 'tmp2') + os.sep
        self.search_folder = os.path.join(tmpfolder, 'index') + os.sep
            
        os.mkdir(self.folder1)
        os.mkdir(self.folder2)
        
        os.mkdir(os.path.join(self.folder1, 'folder1'))
        os.mkdir(os.path.join(self.folder1, 'folder2'))
        os.mkdir(os.path.join(self.folder2, 'folder2'))
        os.mkdir(os.path.join(self.folder2, 'folder3'))
            
        f = open(os.path.join(self.folder1, 'folder1', 'file1'), 'w')
        f.write('-'*5)
        f.close()
            
        f = open(os.path.join(self.folder1, 'folder2', 'file1'), 'w')
        f.write('-'*10)
        f.close()
            
        f = open(os.path.join(self.folder1, 'folder2', 'file2'), 'w')
        f.write('-'*10)
        f.close()
        
        f = open(os.path.join(self.folder2, 'folder2', 'file3'), 'w')
        f.write('-'*10)
        f.close()
        
        f = open(os.path.join(self.folder1, 'file1'), 'w')
        f.write('-'*20)
        f.close()
        
        config = ConfigParser.ConfigParser()
        config.add_section('disks')
        config.set('disks', 'disk1', self.folder1)
        config.set('disks', 'prefix1', '/sdfs/')
        config.set('disks', 'disk2', self.folder2)
        config.set('disks', 'prefix2', '/sdfs/')
        
        config.add_section('general')
        config.set('general', 'externalip', '127.0.0.1')
        config.set('general', 'dbfile', os.path.join(self.dbfolder, 'db.db'))
        config.set('general', 'controlport', '0')
        
        self.sdfsserver = SDFSServer(configfile=config)
        return self.sdfsserver.scan_defer
    
    @defer.inlineCallbacks
    def tearDown(self):
        yield self.sdfsserver.shutdown()
        shutil.rmtree(self.tmpfolder)
        shutil.rmtree(self.dbfolder)
    
    #def testGetHTTPIPNotMatch(self):
    #    def got_file_content(content):
    #        self.fail('Got file content even though IP filter should deny.')
    #    
    #    def failed_file_content(err):
    #        err.trap(error.Error)
    #        # Probably a twisted by that i have to str it
    #        self.failUnlessEqual(err.value.status, str(http.NOT_FOUND), 'Wrong error code')
    #    
    #    def got_file((server_status, result)):
    #        return getPage(result).addCallbacks(got_file_content, failed_file_content)
    #    
    #    return self.sdfsserver.xmlrpc_get_uri('http://0/sdfs/file1?ip=1.2.3.4').addCallback(got_file)
    #
    #def testGetHTTPFileNotFound(self):
    #    def got_file((server_status, result)):
    #        self.fail('Got file when it does not exist')
    #    
    #    def failed_file(err):
    #        err.trap(FileOrFolderNotFoundException)
    #    
    #    return self.sdfsserver.xmlrpc_get_uri('http://0/unknown/file').addCallbacks(got_file, failed_file)
    #
    #def testGetHTTPURI(self):
    #    def got_file_content(content):
    #        self.failUnlessEqual(content, '--------------------', 'Data sent by http plugin is wrong')
    #    
    #    def got_file((server_status, result)):
    #        u = urlparse.urlparse(result)
    #        self.failUnlessEqual(u.scheme, 'http', 'Wrong scheme in returned url')
    #        self.failUnless(re.match('^/[a-zA-Z0-9_-]{28}/file1$', u.path), 'Returned path is invalid, was %s' % u.path)
    #        return getPage(result).addCallback(got_file_content)
    #    return self.sdfsserver.xmlrpc_get_uri('http://0/sdfs/file1').addCallback(got_file)
    #
    #def testGetListURI(self):
    #    def got_listing((server_status, metadata)):
    #        listing = metadata['items']
    #        self.failUnlessIn('status', server_status, 'Server returned no status')
    #        self.failUnlessEqual(server_status['status'], 'idle', 'Server is not idle when it should be')
    #        
    #        self.failUnlessEqual(len(listing), 1, "Too many or too few items returned in listing")
    #        path, listing = listing.items()[0]
    #        self.failUnlessEqual(path, u'')
    #        self.failUnlessEqual(len(listing), 1)
    #        del metadata['items']
    #        self.failUnlessEqual(metadata, {'virtual_path': '', 'name': ''})
    #    
    #    return self.sdfsserver.xmlrpc_get_uri('list://0/').addCallback(got_listing)
    #
    #def testGetListWithDepthURI(self):
    #    def got_listing((server_status, metadata)):
    #        self.failUnlessEqual(len(metadata['items']), 2, 'Wrong number of items returned in depth listing')
    #    
    #    return self.sdfsserver.xmlrpc_get_uri('list://0/?depth=1').addCallback(got_listing)
    #
    #def testGetListUnknownURI(self):
    #    def got_unknown_listing((server_status, (metadata, listing))):
    #        self.fail('Got an actual listing when an exception was appropiate')
    #    def error_unknown_listing(err):
    #        err.trap(FileOrFolderNotFoundException)
    #    return self.sdfsserver.xmlrpc_get_uri('list://0/unknownpath/').addCallbacks(got_unknown_listing, error_unknown_listing)
    #
    #def testGetURIUnknownSchemeException(self):
    #    self.failUnlessRaises(UnknownSchemeException, self.sdfsserver.get_uri, 'unknownscheme://0.0.0.0/')
    #
    #def testRescan(self):
    #    self.failUnlessEqual(self.sdfsserver.scanning, False, 'Error in scan start status')
    #    self.sdfsserver.xmlrpc_rescan()
    #    
    #    def done_scanning(ignored):
    #        self.failUnlessEqual(self.sdfsserver.scanning, False, 'Did not correctly finish the rescan')
    #    
    #    self.failUnlessEqual(self.sdfsserver.server_status()['status'], 'scanning', 'Error in function to get scan status')
    #    self.failUnlessEqual(self.sdfsserver.scanning, True, 'Did not start the scan correctly')
    #    return self.sdfsserver.scan_defer.addCallback(done_scanning)