import os
import shutil
import ConfigParser

from twisted.trial import unittest
from twisted.internet import defer, reactor

from sdfs.server import SDFSServer

from twisted.internet import base
base.DelayedCall.debug = True

class PluginTest(unittest.TestCase):
    def setUp(self):
        self.tmpfolder = os.path.join(os.getcwd(), self.mktemp())
        os.mkdir(self.tmpfolder)
        
        self.dbfolder = dbfolder = os.path.join(os.getcwd(), self.mktemp())
        os.mkdir(dbfolder)
        
        self.pluginfolder = 'something-entertaining'
        self.actualpluginfolder = os.path.join(self.tmpfolder, self.pluginfolder)
        os.mkdir(self.actualpluginfolder)
        
        config = ConfigParser.ConfigParser()
        config.add_section('disks')
        config.set('disks', 'disk1', self.tmpfolder)
        config.set('disks', 'prefix1', '')
        
        config.add_section('general')
        config.set('general', 'externalip', '127.0.0.1')
        config.set('general', 'dbfile', os.path.join(self.dbfolder, 'db.db'))
        config.set('general', 'controlport', '0')
        
        self.sdfsserver = SDFSServer(configfile=config)
        self.filesystem = self.sdfsserver.filesystem
        return self.sdfsserver.scan_defer
    
    @defer.inlineCallbacks
    def testMALPlugin(self):
        f = open(os.path.join(self.actualpluginfolder, 'mal.nfo'), 'w')
        f.write('10')
        f.close()
        
        yield self.filesystem.rescan()
        
        metadata = self.filesystem.list_dir('/')['']
        self.failUnlessEqual(len(metadata), 1, "Too many or too few elements in metadata")
        metadata = metadata[0]
        self.failUnlessIn('plugin:mal:id', metadata, 'No metadata tag found for folder')
        self.failUnlessEqual(metadata['plugin:mal:id'], '10', 'Invalid MAL id found during scanning')
    
    @defer.inlineCallbacks
    def testIMDBPlugin(self):
        f = open(os.path.join(self.actualpluginfolder, 'some-random-nfo.nfo'), 'w')
        f.write('http://www.imdb.com/title/tt0120737/')
        f.close()
        
        yield self.filesystem.rescan()
        
        metadata = self.filesystem.list_dir('/')['']
        self.failUnlessEqual(len(metadata), 1, "Too many or too few elements in metadata")
        metadata = metadata[0]
        self.failUnlessIn('plugin:imdb:id', metadata, 'No metadata tag found for folder')
        self.failUnlessEqual(metadata['plugin:imdb:id'], '120737', 'Invalid IMDB id found during scanning')
    
    @defer.inlineCallbacks
    def tearDown(self):
        yield self.sdfsserver.shutdown()
        shutil.rmtree(self.tmpfolder)
        shutil.rmtree(self.dbfolder)
        for c in reactor.getDelayedCalls():
            c.cancel()