from zope.interface import implements

from twisted.plugin import IPlugin
from twisted.python import log

from sdfs.interfaces import IURIHandler, ICrontab
from sdfs.resource import PluginResource


class LISTURIHandler(PluginResource):
    implements(IPlugin, IURIHandler, ICrontab)
    
    name = 'rescan'
    scheme = 'rescan'
    
    def render_POST(self, request):
        self.filesystem.rescan()
        return {
            'status': 'success',
            'message': 'rescanning'
        }
    
    def rescan(self):
        log.msg('Crontabbed rescan')
        self.filesystem.rescan()
    
    def schedule(self):
        if self.configfile.has_option(self.config_section, 'crontab'):
            return self.configfile.get(self.config_section, 'crontab'), self.rescan
    
    
    
listurihandler = LISTURIHandler()